/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.CleanUpHandler;
import adams.core.io.PlaceholderFile;
import adams.flow.sink.AbstractSink;
import adams.gui.core.BaseFrame;
import adams.gui.print.JComponentWriter;
import adams.gui.print.NullWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;

public abstract class AbstractGraphicsGenerator
extends AbstractSink {
    private static final long serialVersionUID = -3180921421553773745L;
    protected String m_Title;
    protected String m_Suffix;
    protected int m_Width;
    protected int m_Height;
    protected PlaceholderFile m_Output;
    protected JComponentWriter m_Writer;
    protected JComponent m_Component;
    protected BaseFrame m_Frame;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("title", "title", this.getDefaultTitle());
        this.m_OptionManager.add("suffix", "suffix", "");
        this.m_OptionManager.add("width", "width", this.getDefaultWidth());
        this.m_OptionManager.add("height", "height", this.getDefaultHeight());
        this.m_OptionManager.add("output", "output", new PlaceholderFile("."));
        this.m_OptionManager.add("writer", "writer", new NullWriter());
    }

    protected abstract String getDefaultTitle();

    protected abstract int getDefaultWidth();

    protected abstract int getDefaultHeight();

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title of the dialog.";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "An optional suffix for the filename, inserted before the extension.";
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the dialog.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the dialog.";
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public abstract String outputTipText();

    public void setWriter(JComponentWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public JComponentWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for generating the graphics output.";
    }

    protected abstract JComponent generateComponent();

    protected abstract PlaceholderFile generateFilename();

    protected BaseFrame generateFrame() {
        BaseFrame result = new BaseFrame(this.m_Title);
        result.getContentPane().setLayout(new BorderLayout());
        result.getContentPane().add((Component)this.m_Component, "Center");
        result.setSize(this.m_Width, this.m_Height);
        result.setDefaultCloseOperation(1);
        return result;
    }

    protected void displayFrame() {
        this.m_Component = this.generateComponent();
        this.m_Frame = this.generateFrame();
        this.m_Frame.setVisible(true);
        this.m_Frame.toBack();
    }

    protected String generateOutput() {
        String result = null;
        PlaceholderFile filename = this.generateFilename();
        this.debug("Saving to: " + filename);
        this.m_Writer.setComponent(this.m_Component);
        this.m_Writer.setFile(filename);
        try {
            this.m_Writer.toOutput();
        }
        catch (Exception e) {
            result = this.handleException("Failed to write output", e);
        }
        this.m_Writer.setComponent(null);
        return result;
    }

    protected void hideFrame() {
        this.m_Frame.setVisible(false);
        this.m_Frame.dispose();
        this.m_Frame = null;
    }

    protected void disposeComponent() {
        if (this.m_Component instanceof CleanUpHandler) {
            ((CleanUpHandler)((Object)this.m_Component)).cleanUp();
        }
        this.m_Component = null;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (!this.isHeadless()) {
            this.displayFrame();
            result = this.generateOutput();
            this.hideFrame();
            this.disposeComponent();
        }
        return result;
    }
}

