/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.sink.AbstractSink;

public class Console
extends AbstractSink {
    private static final long serialVersionUID = -4999663588509332995L;
    protected String m_Prefix;

    @Override
    public String globalInfo() {
        return "Non-graphical actor that outputs any object that arrives at its input port via the 'toString()' method on stdout.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", "");
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to output before the actual data.";
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("prefix");
        if (variable != null) {
            return variable;
        }
        if (this.m_Prefix != null && this.m_Prefix.length() > 0) {
            return this.m_Prefix;
        }
        return null;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            StringBuilder str = new StringBuilder();
            if (this.m_Prefix.length() > 0) {
                str.append(this.m_Prefix);
            }
            str.append(this.m_InputToken.getPayload().toString());
            this.getSystemOut().println(str.toString());
        }
        catch (Exception e) {
            result = this.handleException("Failed append/output token", e);
        }
        return result;
    }
}

