/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.DateUtils;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.flow.provenance.ProvenanceTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;

public class ProvenanceDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected ProvenanceTree m_Tree;

    @Override
    public String globalInfo() {
        return "Actor for displaying the provenance of a token.";
    }

    @Override
    protected int getDefaultWidth() {
        return 640;
    }

    @Override
    protected int getDefaultHeight() {
        return 480;
    }

    @Override
    public void clearPanel() {
        this.m_Tree.clear();
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        this.m_Tree = new ProvenanceTree();
        result.add((Component)new BaseScrollPane(this.m_Tree), "Center");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void display(Token token) {
        if (token.hasProvenance()) {
            ProvenanceTree provenanceTree = this.m_Tree;
            synchronized (provenanceTree) {
                this.m_Tree.setRoot(token.getProvenance());
            }
        } else {
            this.getSystemErr().println("Token '" + token + "' has no provenance information!");
        }
    }

    @Override
    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractDisplayPanel result = new AbstractDisplayPanel("Provenance"){
            private static final long serialVersionUID = -1491057789366849647L;
            protected ProvenanceTree m_Tree;

            @Override
            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_Tree = new ProvenanceTree();
                this.add((Component)new BaseScrollPane(this.m_Tree), "Center");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void display(Token token) {
                if (token.hasProvenance()) {
                    ProvenanceTree provenanceTree = this.m_Tree;
                    synchronized (provenanceTree) {
                        this.m_Tree.setRoot(token.getProvenance());
                    }
                } else {
                    ProvenanceDisplay.this.getSystemErr().println("Token '" + token + "' has no provenance information!");
                }
            }

            @Override
            public void clearPanel() {
                this.m_Tree.setRoot(null);
            }

            @Override
            public void cleanUp() {
                this.m_Tree.setRoot(null);
            }
        };
        result.display(token);
        return result;
    }

    @Override
    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_Headless) {
            this.getSystemOut().println("\n--> " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\n");
            this.getSystemOut().println(new ProvenanceTree(this.m_InputToken.getProvenance()).toPlainText());
        } else {
            result = super.doExecute();
        }
        return result;
    }

    @Override
    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_Tree != null) {
            this.m_Tree.clear();
            this.m_Tree = null;
        }
    }
}

