/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.io.output.AbstractTextWriter;
import adams.data.io.output.NullWriter;
import adams.flow.sink.AbstractSink;

public class TextWriter
extends AbstractSink {
    private static final long serialVersionUID = 798901949899149659L;
    protected String m_ContentName;
    protected AbstractTextWriter m_Writer;

    @Override
    public String globalInfo() {
        return "Writes incoming textual data to a text file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("content-name", "contentName", "");
        this.m_OptionManager.add("writer", "writer", new NullWriter());
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("writer");
        if (variable != null) {
            return variable;
        }
        if (this.m_Writer != null) {
            return this.m_Writer.getClass().getName();
        }
        return null;
    }

    public void setContentName(String value) {
        this.m_ContentName = value;
        this.reset();
    }

    public String getContentName() {
        return this.m_ContentName;
    }

    public String contentNameTipText() {
        return "The name of the content, might be used in the filename of the output.";
    }

    public void setWriter(AbstractTextWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractTextWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for ouputting the textual data.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result;
        try {
            result = this.m_Writer.write(this.m_InputToken.getPayload().toString(), this.m_ContentName) == null ? "Error writing data: " + this.m_Writer.toCommandLine() : null;
        }
        catch (Exception e) {
            result = this.handleException("Failed to write data:", e);
        }
        return result;
    }
}

