/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.management.OS;
import adams.core.management.ProcessUtils;
import adams.core.option.OptionUtils;
import adams.data.conversion.ConversionFromString;
import adams.data.conversion.StringToString;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import java.util.Vector;

public class Exec
extends AbstractSource {
    private static final long serialVersionUID = -132045002653940359L;
    protected String m_Command;
    protected boolean m_OutputStdErr;
    protected boolean m_SplitOutput;
    protected ConversionFromString m_Conversion;
    protected Vector m_Output;

    @Override
    public String globalInfo() {
        return "Runs an external system command and broadcasts the generated output (stdout or stderr).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cmd", "command", "ls -l .");
        this.m_OptionManager.add("stderr", "outputStdErr", false);
        this.m_OptionManager.add("split-output", "splitOutput", false);
        this.m_OptionManager.add("conversion", "conversion", new StringToString());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Output = new Vector();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Output.clear();
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("command");
        if (variable != null) {
            return variable;
        }
        if (this.m_Command != null && this.m_Command.length() != 0) {
            return this.m_Command;
        }
        return null;
    }

    public void setCommand(String value) {
        this.m_Command = value;
        this.reset();
    }

    public String getCommand() {
        return this.m_Command;
    }

    public String commandTipText() {
        return "The external command to run.";
    }

    public void setOutputStdErr(boolean value) {
        this.m_OutputStdErr = value;
        this.reset();
    }

    public boolean getOutputStdErr() {
        return this.m_OutputStdErr;
    }

    public String outputStdErrTipText() {
        return "If set to true, then stderr is output instead of stdout.";
    }

    public void setSplitOutput(boolean value) {
        this.m_SplitOutput = value;
        this.reset();
    }

    public boolean getSplitOutput() {
        return this.m_SplitOutput;
    }

    public String splitOutputTipText() {
        return "If set to true, then the output gets split on " + (OS.isWindows() ? "CRLF" : "newline") + ".";
    }

    public void setConversion(ConversionFromString value) {
        this.m_Conversion = value;
        this.reset();
    }

    public ConversionFromString getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion scheme to apply to the output.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{this.m_Conversion.generates()};
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.m_Output.clear();
        try {
            ProcessUtils.ProcessResult proc = ProcessUtils.execute(OptionUtils.splitOptions(this.m_Command));
            if (!proc.hasSucceeded()) {
                result = proc.toErrorOutput();
            } else {
                String output = this.m_OutputStdErr ? proc.getStdErr() : proc.getStdOut();
                String[] items = this.m_SplitOutput ? (OS.isWindows() ? output.split("\r\n") : output.split("\n")) : new String[]{output};
                for (String item : items) {
                    this.m_Conversion.setInput(item);
                    String msg = this.m_Conversion.convert();
                    if (msg == null) {
                        this.m_Output.add(this.m_Conversion.getOutput());
                        continue;
                    }
                    this.getSystemErr().println("Failed to convert '" + item + "'!");
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute command: " + this.m_Command, e);
        }
        return result;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Output.get(0));
        this.m_Output.remove(0);
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Output.size() > 0;
    }
}

