/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.Token;
import adams.flow.source.AbstractSource;

public class GetEnvironmentVariable
extends AbstractSource {
    private static final long serialVersionUID = -1036403425216584221L;
    protected String m_Variable;
    protected String m_Value;

    @Override
    public String globalInfo() {
        return "Outputs the value of the specified environment variable.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable", "variable", "");
    }

    @Override
    public String getQuickInfo() {
        String result = "Variable: ";
        String variable = this.getOptionManager().getVariableForProperty("variable");
        result = variable != null ? variable : this.m_Variable;
        return result;
    }

    public void setVariable(String value) {
        this.m_Variable = value;
        this.reset();
    }

    public String getVariable() {
        return this.m_Variable;
    }

    public String variableTipText() {
        return "The name of the environment variable to get.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Value = null;
    }

    @Override
    protected String doExecute() {
        this.m_Value = System.getenv(this.m_Variable);
        return null;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Value);
        this.m_Value = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Value != null;
    }
}

