/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import java.util.ArrayList;
import java.util.Collections;

public class ListSystemProperties
extends AbstractSource {
    private static final long serialVersionUID = -3001964206807357534L;
    protected ArrayList<String> m_Queue;

    @Override
    public String globalInfo() {
        return "Outputs the names of the currently set Java system properties.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Queue = new ArrayList();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Queue.clear();
    }

    @Override
    protected String doExecute() {
        this.m_Queue.clear();
        this.m_Queue.addAll(System.getProperties().stringPropertyNames());
        Collections.sort(this.m_Queue);
        return null;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_Queue.get(0));
        this.m_Queue.remove(0);
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Queue.size() > 0;
    }
}

