/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.ArrayDimensions;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.AbstractSource;
import java.lang.reflect.Array;

public class NewArray
extends AbstractSource {
    private static final long serialVersionUID = 7272049518765623563L;
    protected String m_ArrayClass;
    protected ArrayDimensions m_Dimensions;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Generates a new array of the specified class with the given dimensions.\nDimensions are given as follows: [x], with x being the number of elements. You can have multi-dimensional arrays: [x][y][z]. Variables can be used as well to specify the dimensions: [@{x}].";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("array-class", "arrayClass", String.class.getName());
        this.m_OptionManager.add("dimensions", "dimensions", new ArrayDimensions("[2]"));
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    @Override
    public String getQuickInfo() {
        String result = "Class: ";
        String variable = this.getOptionManager().getVariableForProperty("arrayClass");
        result = variable != null ? result + variable : result + this.m_ArrayClass;
        result = result + ", Dimensions: ";
        variable = this.getOptionManager().getVariableForProperty("dimensions");
        result = variable != null ? result + variable : result + this.m_Dimensions;
        return result;
    }

    public void setArrayClass(String value) {
        this.m_ArrayClass = value;
        this.reset();
    }

    public String getArrayClass() {
        return this.m_ArrayClass;
    }

    public String arrayClassTipText() {
        return "The class to use for the array.";
    }

    public void setDimensions(ArrayDimensions value) {
        this.m_Dimensions = value;
        this.reset();
    }

    public ArrayDimensions getDimensions() {
        return this.m_Dimensions;
    }

    public String dimensionsTipText() {
        return "The dimensions of the array; eg '[2]', '[2][3][7]', '[@{x}]'.";
    }

    protected int[] parseDimensions(String dim) {
        ArrayDimensions dims = new ArrayDimensions();
        dim = this.getVariables().expand(dim);
        if (!dims.isValid(dim)) {
            return null;
        }
        dims.setValue(dim);
        return dims.dimensionsValue();
    }

    @Override
    public Class[] generates() {
        try {
            Class<?> cls = Class.forName(this.m_ArrayClass);
            if (this.parseDimensions(this.m_Dimensions.getValue()) == null) {
                return new Class[]{Unknown.class};
            }
            return new Class[]{Array.newInstance(cls, this.parseDimensions(this.m_Dimensions.getValue())).getClass()};
        }
        catch (Exception e) {
            return new Class[]{Unknown.class};
        }
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.parseDimensions(this.m_Dimensions.getValue()) == null) {
            result = "Failed to parse dimensions: " + this.m_Dimensions.getValue();
        }
        if (result == null) {
            try {
                Class<?> cls = Class.forName(this.m_ArrayClass);
                Object array = Array.newInstance(cls, this.parseDimensions(this.m_Dimensions.getValue()));
                this.m_OutputToken = new Token(array);
            }
            catch (Exception e) {
                result = this.handleException("Failed to create array!", e);
            }
        }
        return result;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

