/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseDate;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseObject;
import adams.core.base.BaseTime;
import adams.flow.core.AutomatableInteractiveActor;
import adams.flow.core.Token;
import adams.flow.source.AbstractInteractiveSource;
import adams.gui.chooser.DatePanel;
import adams.gui.chooser.DateProvider;
import adams.gui.chooser.DateTimePanel;
import adams.gui.chooser.TimePanel;
import adams.gui.core.BasePanel;
import adams.gui.dialog.ApprovalDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.util.Date;

public class SelectDateTime
extends AbstractInteractiveSource
implements AutomatableInteractiveActor {
    private static final long serialVersionUID = 8200691218381875131L;
    protected Type m_Type;
    protected boolean m_OutputAsString;
    protected boolean m_NonInteractive;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Pops up a dialog, prompting the user to select a date/time, date or time value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)Type.DATE_AND_TIME);
        this.m_OptionManager.add("output-as-string", "outputAsString", false);
        this.m_OptionManager.add("non-interactive", "nonInteractive", false);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("type");
        String result = variable != null ? variable : this.m_Type.toString();
        if (this.m_StopFlowIfCanceled) {
            result = result + ", stops flow if canceled";
        }
        if (this.m_OutputAsString) {
            result = result + ", output string";
        }
        if (this.m_NonInteractive) {
            result = result + ", non-interactive";
        }
        return result;
    }

    public void setType(Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of data to output.";
    }

    public void setOutputAsString(boolean value) {
        this.m_OutputAsString = value;
        this.reset();
    }

    public boolean getOutputAsString() {
        return this.m_OutputAsString;
    }

    public String outputAsStringTipText() {
        return "If enabled, a string is output rather than a typed object.";
    }

    @Override
    public void setNonInteractive(boolean value) {
        this.m_NonInteractive = value;
        this.reset();
    }

    @Override
    public boolean isNonInteractive() {
        return this.m_NonInteractive;
    }

    @Override
    public String nonInteractiveTipText() {
        return "If enabled, a value based on the current date/time is forwarded without user interaction.";
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    @Override
    public Class[] generates() {
        if (this.m_OutputAsString) {
            return new Class[]{String.class};
        }
        switch (this.m_Type) {
            case DATE_AND_TIME: {
                return new Class[]{BaseDateTime.class};
            }
            case DATE: {
                return new Class[]{BaseDate.class};
            }
            case TIME: {
                return new Class[]{BaseTime.class};
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
    }

    protected Token createToken(Date dateTime) {
        BaseObject value;
        if (dateTime == null) {
            dateTime = new Date();
        }
        switch (this.m_Type) {
            case DATE_AND_TIME: {
                value = new BaseDateTime(dateTime);
                break;
            }
            case DATE: {
                value = new BaseDate(dateTime);
                break;
            }
            case TIME: {
                value = new BaseTime(dateTime);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
            }
        }
        Token result = this.m_OutputAsString ? new Token(value.toString()) : new Token(value);
        return result;
    }

    @Override
    public boolean doInteract() {
        BasePanel panel;
        String title;
        if (this.m_NonInteractive) {
            this.m_OutputToken = this.createToken(null);
            return true;
        }
        switch (this.m_Type) {
            case DATE_AND_TIME: {
                title = "date and time";
                panel = new DateTimePanel();
                break;
            }
            case DATE: {
                title = "date";
                panel = new DatePanel();
                break;
            }
            case TIME: {
                title = "time";
                panel = new TimePanel();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
            }
        }
        title = "Select " + title;
        ApprovalDialog dialog = new ApprovalDialog(null, Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setTitle(title);
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            this.m_OutputToken = this.createToken(((DateProvider)((Object)panel)).getDate());
            return true;
        }
        return false;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    public static enum Type {
        DATE_AND_TIME,
        DATE,
        TIME;

    }
}

