/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.control.MutableConnectedControlActor;
import adams.flow.control.SequentialDirector;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.InstantiatableActor;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import java.util.Vector;

public class SequenceSource
extends MutableConnectedControlActor
implements OutputProducer,
InstantiatableActor {
    private static final long serialVersionUID = -1007878227244351146L;
    protected transient Vector<Token> m_OutputTokens;

    @Override
    public String globalInfo() {
        return "Encapsulates a sequence of flow items, with the last one generating the output for this meta-source.";
    }

    @Override
    public String actorsTipText() {
        return "All the actors that define this sequence.";
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(true, ActorExecution.SEQUENTIAL, false);
    }

    protected Vector<Token> getOutputTokens() {
        if (this.m_OutputTokens == null) {
            this.m_OutputTokens = new Vector();
        }
        return this.m_OutputTokens;
    }

    protected void addOutputToken(Token output) {
        this.getOutputTokens().add(output);
    }

    @Override
    protected SequentialDirector newDirector() {
        return new SequenceSourceDirector();
    }

    @Override
    public Class[] generates() {
        Class[] result = new Class[]{};
        AbstractActor last = this.lastActive();
        if (last != null && last instanceof OutputProducer) {
            result = ((OutputProducer)((Object)last)).generates();
        }
        return result;
    }

    @Override
    public Token output() {
        Token result;
        if (this.getOutputTokens().size() > 0) {
            result = this.getOutputTokens().get(0);
            this.getOutputTokens().remove(0);
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.getOutputTokens().size() > 0;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_OutputTokens != null) {
            this.m_OutputTokens.clear();
        }
    }

    public static class SequenceSourceDirector
    extends SequentialDirector {
        private static final long serialVersionUID = 1600945233224761728L;

        public void setControlActor(AbstractDirectedControlActor value) {
            if (value instanceof SequenceSource || value == null) {
                super.setControlActor(value);
            } else {
                System.err.println("Group must be a SequenceSource actor (provided: " + (value != null ? value.getClass().getName() : "-null-") + ")!");
            }
        }

        @Override
        protected boolean isFinalOutputRecorded() {
            return true;
        }

        @Override
        protected String doExecuteActors(AbstractActor startActor) {
            String result = super.doExecuteActors(startActor);
            if (result == null) {
                for (int i = 0; i < this.m_FinalOutput.size(); ++i) {
                    ((SequenceSource)this.getControlActor()).addOutputToken((Token)this.m_FinalOutput.get(i));
                }
            }
            return result;
        }
    }
}

