/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.core.AbstractActor;
import adams.flow.sink.GlobalSink;
import adams.flow.standalone.AbstractMultiView;
import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class GridView
extends AbstractMultiView {
    private static final long serialVersionUID = -4454052058077687116L;
    protected int m_NumRows;
    protected int m_NumCols;
    protected Vector<BasePanel> m_Panels;

    @Override
    public String globalInfo() {
        return "Displays multiple graphical actors in a grid. The actors get added row-wise to the grid from top-left to bottom-right. The actors can be referenced in the flow using " + GlobalSink.class.getName() + " actors.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-rows", "numRows", 1, 1, null);
        this.m_OptionManager.add("num-cols", "numCols", 1, 1, null);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Panels = null;
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + ", Rows: ";
        String variable = this.getOptionManager().getVariableForProperty("numRows");
        result = variable != null ? result + variable : result + this.m_NumRows;
        result = result + ", Cols: ";
        variable = this.getOptionManager().getVariableForProperty("numCols");
        result = variable != null ? result + variable : result + this.m_NumCols;
        return result;
    }

    public void setNumRows(int value) {
        this.m_NumRows = value;
        this.reset();
    }

    public int getNumRows() {
        return this.m_NumRows;
    }

    public String numRowsTipText() {
        return "The number of rows in the grid.";
    }

    public void setNumCols(int value) {
        this.m_NumCols = value;
        this.reset();
    }

    public int getNumCols() {
        return this.m_NumCols;
    }

    public String numColsTipText() {
        return "The number of columns in the grid.";
    }

    @Override
    public String actorsTipText() {
        return "The panel-generating actors to display in the grid.";
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new GridLayout(this.m_NumRows, this.m_NumCols));
        this.m_Panels = new Vector();
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            BasePanel panel = new BasePanel(new BorderLayout());
            JLabel label = new JLabel(((AbstractActor)this.m_Actors.get(i)).getName(), 0);
            panel.add((Component)label, "Center");
            result.add(panel);
            this.m_Panels.add(panel);
        }
        return result;
    }

    @Override
    public void addPanel(AbstractActor actor, BasePanel panel) {
        int index = this.indexOf(actor.getName());
        this.m_Panels.set(index, panel);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                GridView.this.m_Panel.removeAll();
                for (BasePanel p : GridView.this.m_Panels) {
                    GridView.this.m_Panel.add(p);
                }
                GridView.this.m_Panel.validate();
                GridView.this.m_Panel.doLayout();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public JComponent supplyComponent() {
        return this.m_Panel;
    }

    @Override
    public void cleanUp() {
        if (this.m_Panels != null) {
            this.m_Panels.clear();
            this.m_Panels = null;
        }
        super.cleanUp();
    }
}

