/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.core.AbstractActor;
import adams.flow.sink.GlobalSink;
import adams.flow.standalone.AbstractMultiView;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class TabView
extends AbstractMultiView {
    private static final long serialVersionUID = -4454052058077687116L;
    protected BaseTabbedPane m_TabbedPane;

    @Override
    public String globalInfo() {
        return "Displays multiple graphical actors in a tabbed pane. The actors can be referenced in the flow using " + GlobalSink.class.getName() + " actors.";
    }

    @Override
    public String actorsTipText() {
        return "The panel-generating actors to display in the tabbed pane.";
    }

    @Override
    protected BasePanel newPanel() {
        BasePanel result = new BasePanel(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        result.add((Component)this.m_TabbedPane, "Center");
        for (int i = 0; i < this.m_Actors.size(); ++i) {
            BasePanel panel = new BasePanel(new BorderLayout());
            JLabel label = new JLabel(((AbstractActor)this.m_Actors.get(i)).getName(), 0);
            panel.add((Component)label, "Center");
            this.m_TabbedPane.addTab(((AbstractActor)this.m_Actors.get(i)).getName(), panel);
        }
        return result;
    }

    @Override
    public void addPanel(AbstractActor actor, BasePanel panel) {
        int index = this.indexOf(actor.getName());
        this.m_TabbedPane.setComponentAt(index, panel);
    }

    @Override
    public JComponent supplyComponent() {
        if (this.m_TabbedPane.getSelectedComponent() instanceof JComponent) {
            return (JComponent)this.m_TabbedPane.getSelectedComponent();
        }
        return null;
    }
}

