/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.CleanUpHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.InteractiveActor;
import adams.flow.transformer.AbstractTransformer;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public abstract class AbstractInteractiveTransformerDialog
extends AbstractTransformer
implements InteractiveActor {
    private static final long serialVersionUID = -9002360111241208309L;
    protected boolean m_ShortTitle;
    protected int m_Width;
    protected int m_Height;
    protected int m_X;
    protected int m_Y;
    protected BasePanel m_Panel;
    protected BaseDialog m_Dialog;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected Boolean m_SuccessfulInteraction;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("short-title", "shortTitle", false);
        this.m_OptionManager.add("width", "width", this.getDefaultWidth(), 1, null);
        this.m_OptionManager.add("height", "height", this.getDefaultHeight(), 1, null);
        this.m_OptionManager.add("x", "x", this.getDefaultX(), -3, null);
        this.m_OptionManager.add("y", "y", this.getDefaultY(), -3, null);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", "");
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("x");
        String result = "X:";
        result = variable != null ? variable : (this.m_X == -1 ? result + "left" : (this.m_X == -2 ? result + "center" : (this.m_X == -3 ? result + "right" : result + this.m_X)));
        variable = this.getOptionManager().getVariableForProperty("y");
        result = result + ", Y:";
        result = variable != null ? result + variable : (this.m_Y == -1 ? result + "top" : (this.m_Y == -2 ? result + "center" : (this.m_Y == -3 ? result + "bottom" : result + this.m_Y)));
        variable = this.getOptionManager().getVariableForProperty("width");
        result = result + ", W:";
        result = variable != null ? result + variable : result + this.m_Width;
        variable = this.getOptionManager().getVariableForProperty("height");
        result = result + ", H:";
        result = variable != null ? result + variable : result + this.m_Height;
        return result;
    }

    protected int getDefaultX() {
        return -1;
    }

    protected int getDefaultY() {
        return -1;
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void setShortTitle(boolean value) {
        this.m_ShortTitle = value;
        this.reset();
    }

    public boolean getShortTitle() {
        return this.m_ShortTitle;
    }

    public String shortTitleTipText() {
        return "If enabled uses just the name for the title instead of the actor's full name.";
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the dialog.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the dialog.";
    }

    public void setX(int value) {
        this.m_X = value;
        this.reset();
    }

    public int getX() {
        return this.m_X;
    }

    public String xTipText() {
        return "The X position of the dialog (>=0: absolute, -1: left, -2: center, -3: right).";
    }

    public void setY(int value) {
        this.m_Y = value;
        this.reset();
    }

    public int getY() {
        return this.m_Y;
    }

    public String yTipText() {
        return "The Y position of the dialog (>=0: absolute, -1: top, -2: center, -3: bottom).";
    }

    @Override
    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    @Override
    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    @Override
    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    @Override
    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    @Override
    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    @Override
    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    @Override
    protected void reset() {
        super.reset();
        this.cleanUpGUI();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Panel = null;
        this.m_Dialog = null;
    }

    public abstract void clearPanel();

    protected abstract BasePanel newPanel();

    public BasePanel getPanel() {
        return this.m_Panel;
    }

    protected String createTitle() {
        if (this.m_ShortTitle) {
            return this.getName();
        }
        return this.getFullName();
    }

    protected void preCreateDialog(BasePanel panel) {
    }

    protected BaseDialog doCreateDialog(BasePanel panel) {
        BaseDialog result = new BaseDialog(null, this.createTitle(), Dialog.ModalityType.DOCUMENT_MODAL);
        int width = Math.min(GUIHelper.getScreenBounds((Window)result).width - this.m_X, this.getWidth());
        int height = Math.min(GUIHelper.getScreenBounds((Window)result).height - this.m_Y, this.getHeight());
        result.getContentPane().setLayout(new BorderLayout());
        result.getContentPane().add((Component)panel, "Center");
        result.setDefaultCloseOperation(1);
        result.setSize(width, height);
        ImageIcon icon = GUIHelper.getIcon(this.getClass());
        if (icon != null) {
            result.setIconImage(icon.getImage());
        } else {
            result.setIconImage(GUIHelper.getIcon("flow.gif").getImage());
        }
        if (panel instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)panel)).getMenuBar());
        } else if (this instanceof MenuBarProvider) {
            result.setJMenuBar(((MenuBarProvider)((Object)this)).getMenuBar());
        }
        result.setLocation(ActorUtils.determineLocation(result, this.m_X, this.m_Y));
        return result;
    }

    protected void postCreateDialog(BaseDialog dialog, BasePanel panel) {
    }

    protected BaseDialog createDialog(BasePanel panel) {
        this.preCreateDialog(panel);
        BaseDialog result = this.doCreateDialog(panel);
        this.postCreateDialog(result, panel);
        return result;
    }

    public BaseDialog getDialog() {
        return this.m_Dialog;
    }

    @Override
    public boolean doInteract() {
        this.m_Dialog.setVisible(true);
        return true;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (!this.isHeadless()) {
            if (this.m_Panel == null) {
                this.m_Panel = this.newPanel();
                this.m_Dialog = this.createDialog(this.m_Panel);
            }
            if (!this.doInteract()) {
                if (this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        this.stopExecution("Flow canceled: " + this.getFullName());
                    } else {
                        this.stopExecution(this.m_CustomStopMessage);
                    }
                } else {
                    result = "User cancelled dialog!";
                }
            }
        }
        return result;
    }

    protected void cleanUpGUI() {
        if (this.m_Dialog != null) {
            if (this.m_Panel instanceof CleanUpHandler) {
                ((CleanUpHandler)((Object)this.m_Panel)).cleanUp();
            }
            this.m_Dialog.setVisible(false);
            this.m_Dialog.dispose();
            this.m_Dialog = null;
            this.m_Panel = null;
        }
    }

    @Override
    public void stopExecution() {
        if (this.m_Dialog != null && this.m_Dialog.isVisible()) {
            this.m_Dialog.setVisible(false);
        }
        super.stopExecution();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbstractInteractiveTransformerDialog.this.cleanUpGUI();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

