/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.Utils;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;

public class ArraySubset
extends AbstractTransformer {
    private static final long serialVersionUID = 8536100625511019961L;
    protected Range m_Elements;

    @Override
    public String globalInfo() {
        return "Generates a subset of the array, using the specified array elements.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("elements", "elements", new Range("first-last"));
    }

    public void setElements(Range value) {
        this.m_Elements = value;
        this.reset();
    }

    public Range getElements() {
        return this.m_Elements;
    }

    public String elementsTipText() {
        return "The range of elements to pick from the array; " + this.m_Elements.getExample();
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("elements");
        if (variable != null) {
            return variable;
        }
        return this.m_Elements.getRange();
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object arrayOld = this.m_InputToken.getPayload();
        this.m_Elements.setMax(Array.getLength(arrayOld));
        int[] indices = this.m_Elements.getIntIndices();
        Object arrayNew = Array.newInstance(arrayOld.getClass().getComponentType(), indices.length);
        for (int i = 0; i < indices.length; ++i) {
            Array.set(arrayNew, i, Utils.deepCopy(Array.get(arrayOld, indices[i])));
        }
        this.m_OutputToken = new Token(arrayNew);
        return result;
    }
}

