/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class GetArrayElement
extends AbstractTransformer {
    private static final long serialVersionUID = -3483275959738804271L;
    protected Index m_Index;

    @Override
    public String globalInfo() {
        return "Picks an element from an array and forwards only this element.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", new Index("1"));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Index = new Index();
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the element to pick; " + this.m_Index.getExample();
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("index");
        return "Index = " + (variable == null ? this.m_Index.getIndex() : variable);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Object[] array = (Object[])this.m_InputToken.getPayload();
            this.m_Index.setMax(array.length);
            this.m_OutputToken = new Token(array[this.m_Index.getIntIndex()]);
        }
        catch (Exception e) {
            result = this.handleException("Failed to get array element: " + this.m_Index.getIndex(), e);
        }
        return result;
    }
}

