/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.option.OptionUtils;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.lang.reflect.Array;

public class SetArrayElement
extends AbstractTransformer {
    private static final long serialVersionUID = -5436016357221787534L;
    protected Index m_Index;
    protected Origin m_Origin;
    protected String m_Value;
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Sets an element of an array and forwards the updated array.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", new Index("1"));
        this.m_OptionManager.add("origin", "origin", (Object)Origin.VALUE);
        this.m_OptionManager.add("value", "value", "");
        this.m_OptionManager.add("storage-name", "storageName", new StorageName());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Index = new Index();
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the element to set; " + this.m_Index.getExample();
    }

    public void setOrigin(Origin value) {
        this.m_Origin = value;
        this.reset();
    }

    public Origin getOrigin() {
        return this.m_Origin;
    }

    public String originTipText() {
        return "Whether to use the provided 'value' or get the data from storage.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set in the array (if origin is " + (Object)((Object)Origin.VALUE) + ").";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored value to use (if origin is " + (Object)((Object)Origin.STORAGE) + ").";
    }

    @Override
    public String getQuickInfo() {
        String result = "Index = ";
        String variable = this.getOptionManager().getVariableForProperty("index");
        result = result + (variable == null ? this.m_Index.getIndex() : variable);
        switch (this.m_Origin) {
            case VALUE: {
                result = result + ", Value = ";
                variable = this.getOptionManager().getVariableForProperty("value");
                if (variable != null) {
                    result = result + variable;
                    break;
                }
                result = result + "\"" + this.m_Value + "\"";
                break;
            }
            case STORAGE: {
                result = result + ", Storage = ";
                variable = this.getOptionManager().getVariableForProperty("storageName");
                if (variable != null) {
                    result = result + variable;
                    break;
                }
                result = result + this.m_StorageName;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled origin: " + (Object)((Object)this.m_Origin));
            }
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Object[] array = (Object[])this.m_InputToken.getPayload();
            this.m_Index.setMax(array.length);
            switch (this.m_Origin) {
                case VALUE: {
                    Array.set(array, this.m_Index.getIntIndex(), OptionUtils.valueOf(array.getClass().getComponentType(), this.m_Value));
                    break;
                }
                case STORAGE: {
                    Array.set(array, this.m_Index.getIntIndex(), this.getStorageHandler().getStorage().get(this.m_StorageName));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled origin: " + (Object)((Object)this.m_Origin));
                }
            }
            this.m_OutputToken = new Token(array);
        }
        catch (Exception e) {
            result = this.handleException("Failed to set array element: " + this.m_Index.getIndex(), e);
        }
        return result;
    }

    public static enum Origin {
        VALUE,
        STORAGE;

    }
}

