/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.Placeholders;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.flow.transformer.AbstractStringOperation;

public class StringInsert
extends AbstractStringOperation {
    private static final long serialVersionUID = 9030574317512531337L;
    protected Index m_Position;
    protected boolean m_After;
    protected BaseString m_Value;
    protected boolean m_ValueContainsPlaceholder;
    protected boolean m_ValueContainsVariable;

    @Override
    public String globalInfo() {
        return "Inserts a user-specified string at a specific position into tokens coming through.\nThe actor is most useful when attaching a variable to the 'value' option, which allows the value to change dynamically then.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Position = new Index();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("position", "position", new Index("last"));
        this.m_OptionManager.add("after", "after", false);
        this.m_OptionManager.add("value", "value", new BaseString(""));
        this.m_OptionManager.add("placeholder", "valueContainsPlaceholder", false);
        this.m_OptionManager.add("variable", "valueContainsVariable", false);
    }

    @Override
    public String getQuickInfo() {
        String result = this.m_After ? "after: " : "at: ";
        String variable = this.getOptionManager().getVariableForProperty("position");
        result = variable != null ? result + variable : result + this.m_Position.getIndex();
        result = result + ", insert: ";
        variable = this.getOptionManager().getVariableForProperty("value");
        result = variable != null ? result + variable : result + "'" + this.getValue() + "'";
        if (this.m_ValueContainsPlaceholder || this.m_ValueContainsVariable) {
            result = result + " [";
            if (this.m_ValueContainsPlaceholder) {
                result = result + "PH";
            }
            if (this.m_ValueContainsVariable) {
                if (!result.endsWith("[")) {
                    result = result + ", ";
                }
                result = result + "Var";
            }
            result = result + "]";
        }
        return result;
    }

    public void setPosition(Index value) {
        this.m_Position = value;
        this.reset();
    }

    public Index getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position where to insert the string; " + this.m_Position.getExample();
    }

    public void setAfter(boolean value) {
        this.m_After = value;
        this.reset();
    }

    public boolean getAfter() {
        return this.m_After;
    }

    public String afterTipText() {
        return "If enabled, the string is inserted after the position instead of at the position.";
    }

    public void setValue(BaseString value) {
        this.m_Value = new BaseString(Utils.unbackQuoteChars(value.getValue()));
        this.reset();
    }

    public BaseString getValue() {
        return new BaseString(Utils.backQuoteChars(this.m_Value.getValue()));
    }

    public String valueTipText() {
        return "The value to insert in the string; you can use '\\t' for tab, '\\n' for line-feed and '\\r' for carriage-return.";
    }

    public void setValueContainsPlaceholder(boolean value) {
        this.m_ValueContainsPlaceholder = value;
        this.reset();
    }

    public boolean getValueContainsPlaceholder() {
        return this.m_ValueContainsPlaceholder;
    }

    public String valueContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the value string.";
    }

    public void setValueContainsVariable(boolean value) {
        this.m_ValueContainsVariable = value;
        this.reset();
    }

    public boolean getValueContainsVariable() {
        return this.m_ValueContainsVariable;
    }

    public String valueContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the value string.";
    }

    @Override
    protected String process(String s) {
        int i;
        String value = this.m_Value.getValue();
        if (this.m_ValueContainsVariable) {
            value = this.getVariables().expand(value);
        }
        if (this.m_ValueContainsPlaceholder) {
            value = Placeholders.getSingleton().expand(value).replace("\\", "/");
        }
        this.m_Position.setMax(s.length());
        int pos = this.m_Position.getIntIndex();
        if (pos == -1) {
            return null;
        }
        if (this.m_After) {
            ++pos;
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < pos && i < s.length(); ++i) {
            result.append(s.charAt(i));
        }
        result.append(value);
        for (i = pos; i < s.length(); ++i) {
            result.append(s.charAt(i));
        }
        return result.toString();
    }
}

