/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import java.util.Date;

public class Timestamp
extends AbstractTransformer {
    private static final long serialVersionUID = 1753400674063204204L;
    protected String m_Format;
    protected transient DateFormat m_Formatter;

    @Override
    public String globalInfo() {
        return "Creates a timestamp string whenever it receives an input token.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", this.getDefaultFormat());
    }

    protected synchronized DateFormat getFormatter() {
        if (this.m_Formatter == null) {
            this.m_Formatter = new DateFormat(this.m_Format);
        }
        return this.m_Formatter;
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("format");
        if (variable != null) {
            return variable;
        }
        if (this.m_Format != null && this.m_Format.length() > 0) {
            return this.m_Format;
        }
        return null;
    }

    protected String getDefaultFormat() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public void setFormat(String value) {
        this.m_Format = value;
        this.reset();
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format of the timestamp to generate, see Javadoc of SimpleDateFormat class. The class is located in the java.text package";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            try {
                this.getFormatter().applyPattern(this.m_Format);
            }
            catch (Exception e) {
                result = this.handleException("Failed to set pattern '" + this.m_Format + "': ", e);
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_OutputToken = new Token(this.getFormatter().format(new Date()));
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to format date: ", e);
        }
        return result;
    }
}

