/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.gui.chooser.FontChooser;
import adams.gui.core.GUIHelper;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JInternalFrame;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class BaseTextPane
extends JTextPane {
    private static final long serialVersionUID = 5053144101104728014L;

    public BaseTextPane() {
        this.initialize();
    }

    public BaseTextPane(StyledDocument doc) {
        super(doc);
        this.initialize();
    }

    protected void initialize() {
    }

    public Frame getParentFrame() {
        return GUIHelper.getParentFrame(this);
    }

    public Dialog getParentDialog() {
        return GUIHelper.getParentDialog(this);
    }

    public JInternalFrame getParentInternalFrame() {
        return GUIHelper.getParentInternalFrame(this);
    }

    public void printText() {
        try {
            this.print(null, null, true, null, null, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "Failed to print:\n" + ex;
            if (this.getParentDialog() != null) {
                GUIHelper.showErrorMessage(this.getParentDialog(), msg);
            }
            GUIHelper.showErrorMessage(this.getParentFrame(), msg);
        }
    }

    public void selectFont() {
        FontChooser chooser = this.getParentDialog() != null ? new FontChooser(this.getParentDialog()) : new FontChooser(this.getParentFrame());
        chooser.setCurrent(this.getFont());
        chooser.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        chooser.setVisible(true);
        this.setTextFont(chooser.getCurrent());
    }

    @MixedCopyright(author="Philip Isenhour", copyright="2003-2007 Philip Isenhour", license=License.PUBLIC_DOMAIN, url="http://javatechniques.com/blog/setting-jtextpane-font-and-color/")
    public void setTextFont(Font font) {
        MutableAttributeSet attrs = this.getInputAttributes();
        StyleConstants.setFontFamily(attrs, font.getFamily());
        StyleConstants.setFontSize(attrs, font.getSize());
        StyleConstants.setItalic(attrs, (font.getStyle() & 2) != 0);
        StyleConstants.setBold(attrs, (font.getStyle() & 1) != 0);
        StyledDocument doc = this.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
    }

    public int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean gotoLine(int index) {
        if (index < 0) {
            return false;
        }
        Document document = this.getDocument();
        synchronized (document) {
            Element root = this.getDocument().getDefaultRootElement();
            if (root.getElementCount() <= index) {
                return false;
            }
            this.setCaretPosition(root.getElement(index).getStartOffset());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int caretToLine(int position) {
        int result = -1;
        Document document = this.getDocument();
        synchronized (document) {
            Element root = this.getDocument().getDefaultRootElement();
            for (int i = 0; i < root.getElementCount(); ++i) {
                Element child = root.getElement(i);
                if (child.getStartOffset() < position || position > child.getEndOffset()) continue;
                result = i;
                break;
            }
        }
        return result;
    }
}

