/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BaseTreeNode;
import adams.gui.core.GUIHelper;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BaseTree
extends JTree {
    private static final long serialVersionUID = 7574481276254738172L;

    public BaseTree() {
        this.initialize();
    }

    public BaseTree(TreeModel model) {
        super(model);
        this.initialize();
    }

    public BaseTree(TreeNode root) {
        super(root);
        this.initialize();
    }

    protected void initialize() {
        this.setRowHeight(0);
    }

    public void expand(DefaultMutableTreeNode node) {
        this.expandPath(new TreePath(node.getPath()));
    }

    public void expandAll() {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        if (root != null) {
            this.toggleAll(new TreePath(root), true);
        }
    }

    public void expandAll(DefaultMutableTreeNode node) {
        this.expandAll(new TreePath(node.getPath()));
    }

    public void expandAll(TreePath path) {
        this.toggleAll(path, true);
    }

    public void collapse(DefaultMutableTreeNode node) {
        this.collapsePath(new TreePath(node.getPath()));
    }

    public void collapseAll() {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        if (root != null) {
            this.toggleAll(new TreePath(root), false);
        }
    }

    public void collapseAll(DefaultMutableTreeNode node) {
        this.collapseAll(new TreePath(node.getPath()));
    }

    public void collapseAll(TreePath path) {
        this.toggleAll(path, false);
    }

    protected void toggleAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            this.toggleAll(parent.pathByAddingChild(child), expand);
        }
        if (expand) {
            this.expandPath(parent);
        } else {
            this.collapsePath(parent);
        }
    }

    public boolean isRootSelected() {
        TreePath path = new TreePath(this.getModel().getRoot());
        boolean result = this.isPathSelected(path);
        return result;
    }

    public void redraw() {
        if (this.getModel().getRoot() != null) {
            this.redraw((TreeNode)this.getModel().getRoot());
        }
    }

    public void redraw(TreeNode node) {
        if (this.getModel() instanceof DefaultTreeModel) {
            ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
        }
    }

    public Frame getParentFrame() {
        return GUIHelper.getParentFrame(this);
    }

    public Dialog getParentDialog() {
        return GUIHelper.getParentDialog(this);
    }

    public JInternalFrame getParentInternalFrame() {
        return GUIHelper.getParentInternalFrame(this);
    }

    public void setExpandedState(boolean[] value) {
        for (int i = 0; i < value.length; ++i) {
            if (!value[i]) continue;
            this.expandRow(i);
        }
    }

    public boolean[] getExpandedState() {
        boolean[] result = new boolean[this.getRowCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.isExpanded(i);
        }
        return result;
    }

    public void setExpandedStateList(List<Boolean> value) {
        for (int i = 0; i < value.size(); ++i) {
            if (!value.get(i).booleanValue()) continue;
            this.expandRow(i);
        }
    }

    public List<Boolean> getExpandedStateList() {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            result.add(this.isExpanded(i));
        }
        return result;
    }

    public BaseTreeNode getCommonAncestor(BaseTreeNode node1, BaseTreeNode node2) {
        BaseTreeNode result = null;
        TreeNode[] path1 = node1.getPath();
        TreeNode[] path2 = node2.getPath();
        for (int i = 0; i < path1.length && i < path2.length && path1[i].equals(path2[i]); ++i) {
            result = (BaseTreeNode)path1[i];
        }
        return result;
    }

    protected void toString(StringBuilder builder, int level, TreeNode node, Vector<Boolean> more) {
        int i;
        StringBuilder indentStr = new StringBuilder();
        for (i = 0; i < level; ++i) {
            if (more.get(i).booleanValue()) {
                indentStr.append("| ");
                continue;
            }
            indentStr.append("  ");
        }
        if (level > 0) {
            builder.append((CharSequence)indentStr);
            builder.append("|\n");
        }
        builder.append((CharSequence)indentStr);
        builder.append("+ " + node.toString() + "\n");
        for (i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            more.add(i < node.getChildCount() - 1);
            this.toString(builder, level + 1, child, more);
            more.remove(more.size() - 1);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        Object root = this.getModel().getRoot();
        if (root instanceof TreeNode) {
            Vector<Boolean> more = new Vector<Boolean>();
            more.add(false);
            this.toString(result, 0, (TreeNode)root, more);
        } else {
            result.append("Cannot generate tree!");
        }
        return result.toString();
    }

    public String toPlainText() {
        StringBuilder result = new StringBuilder();
        Object root = this.getModel().getRoot();
        if (root instanceof BaseTreeNode) {
            Vector<Boolean> more = new Vector<Boolean>();
            more.add(false);
            this.toPlainText(result, 0, (BaseTreeNode)root, more);
        } else {
            result.append("Cannot generate tree!");
        }
        return result.toString();
    }

    protected void toPlainText(StringBuilder builder, int level, BaseTreeNode node, Vector<Boolean> more) {
        int i;
        StringBuilder indentStr = new StringBuilder();
        for (i = 0; i < level; ++i) {
            if (more.get(i).booleanValue()) {
                indentStr.append("| ");
                continue;
            }
            indentStr.append("  ");
        }
        if (level > 0) {
            builder.append((CharSequence)indentStr);
            builder.append("|\n");
        }
        String[] lines = node.toPlainText().split("\n");
        for (i = 0; i < lines.length; ++i) {
            builder.append((CharSequence)indentStr);
            if (i == 0) {
                builder.append("+ ");
            } else {
                builder.append("  ");
            }
            builder.append(lines[i] + "\n");
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            TreeNode child = node.getChildAt(i);
            more.add(i < node.getChildCount() - 1);
            this.toPlainText(builder, level + 1, (BaseTreeNode)child, more);
            more.remove(more.size() - 1);
        }
    }
}

