/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.data.spreadsheet.Cell;
import adams.gui.core.SpreadSheetTable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SpreadSheetCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -6070112998601610760L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        SpreadSheetTable stable = (SpreadSheetTable)table;
        Cell cell = stable.getCellAt(row, column);
        boolean numeric = false;
        Double numericVal = null;
        if (cell != null) {
            if (!(cell.isFormula() && stable.getShowFormulas() || !(numeric = cell.isNumeric()) || !stable.hasNegativeBackground() && !stable.hasPositiveBackground())) {
                numericVal = cell.toDouble();
            }
            if (cell.isMissing()) {
                ((JLabel)result).setToolTipText("missing");
                if (isSelected) {
                    ((JLabel)result).setBackground(Color.GRAY);
                } else {
                    ((JLabel)result).setBackground(Color.LIGHT_GRAY);
                }
            } else {
                ((JLabel)result).setToolTipText(null);
                if (isSelected) {
                    if (numericVal != null && numericVal >= 0.0 && stable.hasPositiveBackground()) {
                        ((JLabel)result).setBackground(stable.getPositiveBackground().darker());
                    } else if (numericVal != null && numericVal < 0.0 && stable.hasNegativeBackground()) {
                        ((JLabel)result).setBackground(stable.getNegativeBackground().darker());
                    } else {
                        ((JLabel)result).setBackground(stable.getSelectionBackground());
                    }
                } else if (numericVal != null && numericVal >= 0.0 && stable.hasPositiveBackground()) {
                    ((JLabel)result).setBackground(stable.getPositiveBackground());
                } else if (numericVal != null && numericVal < 0.0 && stable.hasNegativeBackground()) {
                    ((JLabel)result).setBackground(stable.getNegativeBackground());
                } else {
                    ((JLabel)result).setBackground(stable.getBackground());
                }
            }
            if (numeric) {
                ((JLabel)result).setHorizontalAlignment(4);
            } else {
                ((JLabel)result).setHorizontalAlignment(2);
            }
        } else {
            if (column == 0) {
                ((JLabel)result).setHorizontalAlignment(0);
            }
            if (column > 0) {
                ((JLabel)result).setToolTipText("missing");
                if (isSelected) {
                    ((JLabel)result).setBackground(Color.GRAY);
                } else {
                    ((JLabel)result).setBackground(Color.LIGHT_GRAY);
                }
            }
        }
        return result;
    }
}

