/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Utils;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.AbstractBaseTableModel;
import java.awt.Color;

public class SpreadSheetTableModel
extends AbstractBaseTableModel {
    private static final long serialVersionUID = 8062515320279133441L;
    protected SpreadSheet m_Sheet;
    protected int m_NumDecimals;
    protected Color m_BackgroundNegative;
    protected Color m_BackgroundPositive;
    protected boolean m_ShowFormulas;

    public SpreadSheetTableModel() {
        this(new SpreadSheet());
    }

    public SpreadSheetTableModel(SpreadSheet sheet) {
        this(sheet, -1);
    }

    public SpreadSheetTableModel(SpreadSheet sheet, int numDec) {
        this.m_Sheet = sheet;
        this.m_NumDecimals = numDec;
        this.m_BackgroundNegative = null;
        this.m_BackgroundPositive = null;
        this.m_ShowFormulas = false;
    }

    @Override
    public int getRowCount() {
        return this.m_Sheet.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.m_Sheet.getColumnCount() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String result;
        if (columnIndex == 0) {
            result = "<html><center>Row<br>1</center></html>";
        } else {
            HeaderRow row = this.m_Sheet.getHeaderRow();
            result = "<html><center><b>" + row.getCell(row.getCellKey(columnIndex - 1)).getContent() + "</b>" + "<br>" + SpreadSheet.getColumnPosition(columnIndex - 1) + " / " + columnIndex + "</center>" + "</html>";
        }
        return result;
    }

    public Class getColumnClass(int columnIndex) {
        Class<String> result = columnIndex == 0 ? String.class : String.class;
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (columnIndex == 0) {
            result = new Integer(rowIndex + 2);
        } else {
            DataRow row = this.m_Sheet.getRow(rowIndex);
            Cell cell = row.getCell(this.m_Sheet.getHeaderRow().getCellKey(columnIndex - 1));
            if (cell == null) {
                result = null;
            } else if (cell.isMissing()) {
                result = null;
            } else if (cell.isFormula() && this.m_ShowFormulas) {
                result = cell.getFormula();
            } else if (cell.isLong()) {
                result = cell.toLong();
            } else if (cell.isDouble()) {
                double d = cell.toDouble();
                if (Double.isNaN(d)) {
                    result = "NaN";
                } else {
                    if (this.m_NumDecimals > -1) {
                        double factor = Math.pow(10.0, this.m_NumDecimals);
                        d = (double)Math.round(d * factor) / factor;
                    }
                    result = Utils.doubleToStringFixed(d, this.m_NumDecimals);
                }
            } else {
                result = cell.getContent();
            }
        }
        return result;
    }

    public Cell getCellAt(int rowIndex, int columnIndex) {
        Cell result = null;
        if (columnIndex > 0) {
            result = this.m_Sheet.getCell(rowIndex, columnIndex - 1);
        }
        return result;
    }

    public void setNumDecimals(int value) {
        if (value >= -1) {
            if (this.m_NumDecimals != value) {
                this.m_NumDecimals = value;
                this.fireTableDataChanged();
            }
        } else {
            System.err.println("Number of displayed decimals must be >=0 or -1 to display all - provided: " + value);
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public boolean hasNegativeBackground() {
        return this.m_BackgroundNegative != null;
    }

    public void setNegativeBackground(Color value) {
        this.m_BackgroundNegative = value;
        this.fireTableDataChanged();
    }

    public Color getNegativeBackground() {
        return this.m_BackgroundNegative;
    }

    public boolean hasPositiveBackground() {
        return this.m_BackgroundPositive != null;
    }

    public void setPositiveBackground(Color value) {
        this.m_BackgroundPositive = value;
        this.fireTableDataChanged();
    }

    public Color getPositiveBackground() {
        return this.m_BackgroundPositive;
    }

    public void setShowFormulas(boolean value) {
        if (this.m_ShowFormulas != value) {
            this.m_ShowFormulas = value;
            this.fireTableDataChanged();
        }
    }

    public boolean getShowFormulas() {
        return this.m_ShowFormulas;
    }

    public SpreadSheet getSheet() {
        return this.m_Sheet;
    }
}

