/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.management.TimeZoneHelper;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;

public class TimeZoneSettingsPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -5325521437739323748L;
    protected ParameterPanel m_PanelParameters;
    protected JComboBox m_ComboBoxTimeZones;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "North");
        this.m_ComboBoxTimeZones = new JComboBox<String>(TimeZoneHelper.getIDs());
        this.m_PanelParameters.addParameter("_Time zone", this.m_ComboBoxTimeZones);
        this.load();
    }

    protected void load() {
        TimeZoneHelper helper = TimeZoneHelper.getSingleton();
        helper.reload();
        this.m_ComboBoxTimeZones.setSelectedItem(helper.getTimezone());
    }

    @Override
    public String getTitle() {
        return "Time zone";
    }

    @Override
    public boolean requiresWrapper() {
        return true;
    }

    @Override
    public String activate() {
        TimeZoneHelper helper = TimeZoneHelper.getSingleton();
        if (this.m_ComboBoxTimeZones.getSelectedIndex() > -1) {
            helper.setTimezone(TimeZoneHelper.getIDs()[this.m_ComboBoxTimeZones.getSelectedIndex()]);
        } else {
            helper.setTimezone("Default");
        }
        boolean result = helper.save();
        helper.initializeTimezone();
        if (result) {
            return null;
        }
        return "Failed to save time zone setup!";
    }
}

