/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItem;
import adams.gui.flow.tree.menu.AbstractTreeShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;

public class RemoveBookmark
extends AbstractTreePopupMenuItem {
    private static final long serialVersionUID = -8991671014421339078L;

    @Override
    protected JMenuItem getMenuItem(final StateContainer state) {
        JMenuItem result = new JMenuItem("Remove bookmark");
        result.setEnabled(this.getShortcut().stateApplies(state));
        result.setAccelerator(this.getShortcut().getKeyStroke());
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoveBookmark.this.getShortcut().execute(state);
            }
        });
        return result;
    }

    @Override
    protected AbstractTreeShortcut newShortcut() {
        return new AbstractTreeShortcut(){
            private static final long serialVersionUID = -7897333416159785241L;

            @Override
            protected String getTreeShortCutKey() {
                return "Bookmark.Remove";
            }

            @Override
            public boolean stateApplies(StateContainer state) {
                return state.numSel > 0;
            }

            @Override
            protected void doExecute(StateContainer state) {
                for (TreePath path : state.selPaths) {
                    Node node = (Node)path.getLastPathComponent();
                    node.setBookmarked(false);
                    state.tree.nodeStructureChanged(node);
                }
            }
        };
    }
}

