/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.AdditionalInformationHandler;
import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.option.AbstractOption;
import adams.gui.core.AbstractScript;
import adams.gui.core.GUIHelper;
import adams.gui.core.StyledTextEditorPanel;
import adams.gui.dialog.TextDialog;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class AbstractScriptEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
InlineEditorSupport {
    protected StyledTextEditorPanel m_TextStatement;

    public static String toString(AbstractOption option, Object object) {
        return ((AbstractScript)object).stringValue();
    }

    public static Object valueOf(Class cls, String str) {
        AbstractScript result;
        try {
            if (cls.isArray()) {
                cls = cls.getComponentType();
            }
            result = (AbstractScript)cls.newInstance();
            result.setValue(Utils.unbackQuoteChars(str));
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public static Object valueOf(AbstractOption option, String str) {
        return AbstractScriptEditor.valueOf(option.getDefaultValue().getClass(), str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return AbstractScriptEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return AbstractScriptEditor.valueOf(this.getValue().getClass(), str);
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + AbstractScriptEditor.toString(null, this.getValue()) + "\")";
        return result;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "null" : AbstractScriptEditor.toString(null, this.getValue());
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        panelAll.setSize(new Dimension(400, 300));
        panelAll.setMinimumSize(new Dimension(400, 300));
        panelAll.setPreferredSize(new Dimension(400, 300));
        panelAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TextStatement = this.getValue() == null ? new StyledTextEditorPanel() : ((AbstractScript)this.getValue()).getTextEditorPanel();
        this.m_TextStatement.setWordWrap(true);
        panelAll.add((Component)this.m_TextStatement, "Center");
        JPanel panelBottom = new JPanel(new BorderLayout());
        panelAll.add((Component)panelBottom, "South");
        JPanel panelButtonsLeft = new JPanel(new FlowLayout(0));
        panelBottom.add((Component)panelButtonsLeft, "West");
        final JButton buttonOptions = new JButton("...");
        buttonOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem menuitem = new JMenuItem("Cut");
                menuitem.setIcon(GUIHelper.getIcon("cut.gif"));
                menuitem.setEnabled(AbstractScriptEditor.this.m_TextStatement.canCut());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractScriptEditor.this.m_TextStatement.cut();
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Copy");
                menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
                menuitem.setEnabled(AbstractScriptEditor.this.m_TextStatement.canCopy());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractScriptEditor.this.m_TextStatement.copy();
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Paste");
                menuitem.setIcon(GUIHelper.getIcon("paste.gif"));
                menuitem.setEnabled(AbstractScriptEditor.this.m_TextStatement.canPaste());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractScriptEditor.this.m_TextStatement.paste();
                    }
                });
                menu.add(menuitem);
                menuitem = new JCheckBoxMenuItem("Line wrap");
                menuitem.setIcon(GUIHelper.getEmptyIcon());
                menuitem.setSelected(AbstractScriptEditor.this.m_TextStatement.getWordWrap());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractScriptEditor.this.m_TextStatement.setWordWrap(((JMenuItem)e.getSource()).isSelected());
                    }
                });
                menu.addSeparator();
                menu.add(menuitem);
                menu.show(buttonOptions, 0, buttonOptions.getHeight());
            }
        });
        panelButtonsLeft.add(buttonOptions);
        JPanel panelButtonsRight = new JPanel(new FlowLayout(2));
        panelBottom.add((Component)panelButtonsRight, "East");
        if (this.m_TextStatement instanceof AdditionalInformationHandler) {
            JButton buttonHelp = new JButton("Help");
            buttonHelp.setMnemonic('H');
            buttonHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String help = ((AdditionalInformationHandler)((Object)AbstractScriptEditor.this.m_TextStatement)).getAdditionalInformation();
                    TextDialog dlg = new TextDialog();
                    dlg.setDefaultCloseOperation(2);
                    dlg.setContent(help);
                    dlg.setLineWrap(true);
                    dlg.setVisible(true);
                }
            });
            panelButtonsRight.add(buttonHelp);
        }
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = AbstractScriptEditor.this.m_TextStatement.getContent();
                if (((AbstractScript)AbstractScriptEditor.this.getValue()).isValid(s) && !s.equals(((AbstractScript)AbstractScriptEditor.this.getValue()).getValue())) {
                    try {
                        AbstractScript newValue = (AbstractScript)AbstractScriptEditor.this.getValue().getClass().newInstance();
                        newValue.setValue(s);
                        AbstractScriptEditor.this.setValue(newValue);
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to create AbstractScript-derived object from '" + s + "':");
                        ex.printStackTrace();
                    }
                }
                AbstractScriptEditor.this.closeDialog(1);
            }
        });
        panelButtonsRight.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractScriptEditor.this.closeDialog(0);
            }
        });
        panelButtonsRight.add(buttonClose);
        return panelAll;
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextStatement.getContent().equals("" + this.getValue())) {
            this.m_TextStatement.setContent("" + this.getValue());
        }
        this.m_TextStatement.setToolTipText(((BaseObject)this.getValue()).getTipText());
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isInlineValueValid(value)) {
            this.setValue(AbstractScriptEditor.valueOf(this.getValue().getClass(), value));
        }
    }

    @Override
    public String getInlineValue() {
        return Utils.backQuoteChars(((BaseObject)this.getValue()).getValue());
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return ((BaseObject)this.getValue()).isValid(Utils.unbackQuoteChars(value));
    }
}

