/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.ClassLocator;
import adams.core.CustomDisplayStringProvider;
import adams.core.Utils;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractOptionProducer;
import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.gui.core.BaseList;
import adams.gui.core.BaseListWithButtons;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.RemoveItemsEvent;
import adams.gui.event.RemoveItemsListener;
import adams.gui.goe.AbstractGenericObjectEditorHandler;
import adams.gui.goe.AdamsEditorsRegistration;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.goe.MultiSelectionEditor;
import adams.gui.goe.PropertyPanel;
import adams.gui.goe.PropertyText;
import adams.gui.goe.PropertyValueSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GenericArrayEditor
extends BasePanel
implements PropertyEditor {
    private static final long serialVersionUID = 3914616975334750480L;
    protected PropertyChangeSupport m_Support;
    protected JLabel m_Label;
    protected BaseListWithButtons m_ElementList;
    protected Class m_ElementClass;
    protected DefaultListModel m_ListModel;
    protected DefaultListModel m_ListModelBackup;
    protected PropertyEditor m_ElementEditor;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected JButton m_ButtonEdit;
    protected JButton m_ButtonUp;
    protected JButton m_ButtonDown;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonAddMultiple;
    protected JButton m_ButtonCopy;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonCancel;
    protected JButton m_ButtonRevert;
    protected JPanel m_PanelDialogButtons;
    protected GenericObjectEditorDialog m_Dialog;
    protected WindowAdapter m_WindowAdapter;
    protected boolean m_Modified;
    protected Component m_View;

    public GenericArrayEditor() {
        AdamsEditorsRegistration.registerEditors();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Support = new PropertyChangeSupport(this);
        this.m_ElementClass = String.class;
        this.m_Modified = false;
        this.m_WindowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GenericArrayEditor.this.restore();
                super.windowClosing(e);
            }
        };
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_Label = new JLabel("Can't edit", 0);
        this.setMinimumSize(new Dimension(500, 300));
        this.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Label, "Center");
        this.m_ButtonAdd = new JButton(GUIHelper.getIcon("add.gif"));
        this.m_ButtonAdd.setToolTipText("Add the current item to the array");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.addObject(GenericArrayEditor.this.m_ElementEditor.getValue());
            }
        });
        this.m_ButtonAddMultiple = new JButton(GUIHelper.getIcon("add_multiple.gif"));
        this.m_ButtonAddMultiple.setToolTipText("Add multiple items to the array");
        this.m_ButtonAddMultiple.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.addMultipleObjects();
            }
        });
        this.m_ButtonCopy = new JButton(GUIHelper.getIcon("copy.gif"));
        this.m_ButtonCopy.setToolTipText("Copies the currently selected array item to the edit field");
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.m_ElementEditor.setValue(Utils.deepCopy(GenericArrayEditor.this.m_ElementList.getSelectedValue()));
            }
        });
        this.m_ButtonRemove = new JButton(GUIHelper.getIcon("delete.gif"));
        this.m_ButtonRemove.setToolTipText("Remove the selected array item(s)");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.removeSelectedObjects();
            }
        });
        this.m_ButtonRemoveAll = new JButton(GUIHelper.getIcon("delete_all.gif"));
        this.m_ButtonRemoveAll.setToolTipText("Remove all the array items");
        this.m_ButtonRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.removeAllObjects();
            }
        });
        this.m_ButtonEdit = new JButton(GUIHelper.getIcon("properties.gif"));
        this.m_ButtonEdit.setToolTipText("Edit the selected array item");
        this.m_ButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.editSelectedObject();
            }
        });
        this.m_ButtonUp = new JButton(GUIHelper.getIcon("arrow_up.gif"));
        this.m_ButtonUp.setToolTipText("Move the selected item(s) one up");
        this.m_ButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.m_ElementList.moveUp();
                GenericArrayEditor.this.m_Modified = true;
                GenericArrayEditor.this.updateButtons();
            }
        });
        this.m_ButtonDown = new JButton(GUIHelper.getIcon("arrow_down.gif"));
        this.m_ButtonDown.setToolTipText("Move the selected item(s) one down");
        this.m_ButtonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.m_ElementList.moveDown();
                GenericArrayEditor.this.m_Modified = true;
                GenericArrayEditor.this.updateButtons();
            }
        });
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        this.m_ButtonOK.setToolTipText("Applies the changes and closes the dialog");
        this.m_ButtonOK.setEnabled(false);
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.apply();
                GenericArrayEditor.this.firePropertyChange();
                GenericArrayEditor.this.close();
            }
        });
        this.m_ButtonCancel = new JButton("Cancel");
        this.m_ButtonCancel.setMnemonic('C');
        this.m_ButtonCancel.setToolTipText("Cancels the dialog");
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.restore();
                GenericArrayEditor.this.updateButtons();
                GenericArrayEditor.this.close();
            }
        });
        this.m_ButtonRevert = new JButton(GUIHelper.getIcon("undo.gif"));
        this.m_ButtonRevert.setToolTipText("Reverts the changes");
        this.m_ButtonRevert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericArrayEditor.this.restore();
            }
        });
        this.m_ElementList = new BaseListWithButtons();
        this.m_ElementList.setDoubleClickButton(this.m_ButtonEdit);
        this.m_ElementList.setInfoVisible(true);
        this.m_ElementList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GenericArrayEditor.this.updateButtons();
            }
        });
        this.m_ElementList.addRemoveItemsListener(new RemoveItemsListener(){

            @Override
            public void removeItems(RemoveItemsEvent e) {
                GenericArrayEditor.this.removeSelectedObjects();
            }
        });
    }

    protected void close() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
        } else {
            this.getParentFrame().setVisible(false);
        }
        if (this.getTopLevelAncestor() != null && this.getTopLevelAncestor() instanceof Window) {
            Window w = (Window)this.getTopLevelAncestor();
            w.dispose();
        }
    }

    protected void updateButtons() {
        this.m_ButtonAddMultiple.setEnabled(this.m_ElementEditor instanceof MultiSelectionEditor);
        this.m_ButtonOK.setEnabled(this.m_Modified);
        this.m_ButtonRevert.setEnabled(this.m_Modified);
        if (this.m_ElementList.getSelectedIndex() != -1) {
            this.m_ButtonCopy.setEnabled(this.m_ElementList.getSelectedIndices().length == 1);
            this.m_ButtonRemove.setEnabled(true);
            this.m_ButtonRemoveAll.setEnabled(true);
            this.m_ButtonEdit.setEnabled(this.m_ElementList.getSelectedIndices().length == 1);
            this.m_ButtonUp.setEnabled(this.m_ElementList.canMoveUp());
            this.m_ButtonDown.setEnabled(this.m_ElementList.canMoveDown());
        } else {
            this.m_ButtonCopy.setEnabled(false);
            this.m_ButtonRemove.setEnabled(false);
            this.m_ButtonRemoveAll.setEnabled(this.m_ListModel.getSize() > 0);
            this.m_ButtonEdit.setEnabled(false);
            this.m_ButtonUp.setEnabled(false);
            this.m_ButtonDown.setEnabled(false);
        }
    }

    protected void apply() {
        this.m_Modified = false;
        Object obj = Array.newInstance(this.m_ElementClass, this.m_ListModel.size());
        for (int i = 0; i < this.m_ListModel.size(); ++i) {
            Array.set(obj, i, Utils.deepCopy(this.m_ListModel.get(i)));
        }
        this.setValue(obj);
        this.updateButtons();
    }

    protected void restore() {
        this.m_ListModel.clear();
        for (int i = 0; i < this.m_ListModelBackup.size(); ++i) {
            this.m_ListModel.addElement(Utils.deepCopy(this.m_ListModelBackup.get(i)));
        }
        this.apply();
    }

    protected void updateEditorType(Object o) {
        this.m_ElementEditor = null;
        this.m_View = null;
        this.m_ListModel = null;
        this.m_ButtonAdd.setIcon(GUIHelper.getIcon("add.gif"));
        this.removeAll();
        if (o != null && o.getClass().isArray()) {
            Class<?> elementClass = o.getClass().getComponentType();
            PropertyEditor editor = PropertyEditorManager.findEditor(elementClass);
            JComponent view = null;
            ListCellRenderer<Object> lcr = new DefaultListCellRenderer();
            if (editor != null) {
                AbstractGenericObjectEditorHandler handler = AbstractGenericObjectEditorHandler.getHandler(editor);
                handler.setClassType(editor, elementClass);
                handler.setCanChangeClassInDialog(editor, true);
                if (Array.getLength(o) > 0) {
                    editor.setValue(Array.get(o, 0));
                } else if (editor instanceof GenericObjectEditor) {
                    ((GenericObjectEditor)editor).setDefaultValue();
                } else if (ClassLocator.isSubclass(Enum.class, elementClass)) {
                    try {
                        Method method = elementClass.getMethod("values", new Class[0]);
                        Object[] obj = (Object[])method.invoke(null, new Object[0]);
                        editor.setValue(obj[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        editor.setValue(elementClass.newInstance());
                    }
                    catch (Exception ex) {
                        this.m_ElementEditor = null;
                        this.m_View = null;
                        ex.printStackTrace();
                        this.add((Component)this.m_Label, "Center");
                        this.firePropertyChange();
                        this.validate();
                        return;
                    }
                }
                if (editor.isPaintable() && editor.supportsCustomEditor()) {
                    view = new PropertyPanel(editor);
                    lcr = new EditorListCellRenderer(editor.getClass(), elementClass);
                } else if (editor.getTags() != null) {
                    view = new PropertyValueSelector(editor);
                } else if (editor.getAsText() != null) {
                    view = new PropertyText(editor);
                }
            }
            if (view == null) {
                System.err.println("No property editor for class: " + elementClass.getName());
            } else {
                JPanel panelAdd;
                JPanel panel = new JPanel();
                panel.setLayout(new BorderLayout());
                panel.add(view, "Center");
                this.add((Component)panel, "North");
                this.m_ElementEditor = editor;
                this.m_View = view;
                this.m_ListModel = new DefaultListModel();
                this.m_ListModelBackup = new DefaultListModel();
                this.m_ElementClass = elementClass;
                for (int i = 0; i < Array.getLength(o); ++i) {
                    this.m_ListModel.addElement(Utils.deepCopy(Array.get(o, i)));
                    this.m_ListModelBackup.addElement(Utils.deepCopy(Array.get(o, i)));
                }
                ((BaseList)this.m_ElementList.getComponent()).setCellRenderer(lcr);
                this.m_ElementList.setModel(this.m_ListModel);
                if (this.m_ListModel.getSize() > 0) {
                    this.m_ElementList.setSelectedIndex(0);
                }
                this.add((Component)this.m_ElementList, "Center");
                if (this.m_ElementEditor instanceof MultiSelectionEditor) {
                    panelAdd = new JPanel(new GridLayout(1, 2, 0, 0));
                    panelAdd.add(this.m_ButtonAdd);
                    panelAdd.add(this.m_ButtonAddMultiple);
                } else {
                    panelAdd = new JPanel(new GridLayout(1, 1, 0, 0));
                    panelAdd.add(this.m_ButtonAdd);
                }
                JPanel panelMove = new JPanel(new GridLayout(1, 2, 0, 0));
                panelMove.add(this.m_ButtonUp);
                panelMove.add(this.m_ButtonDown);
                JPanel panelCopyEdit = new JPanel(new GridLayout(1, 2, 0, 0));
                panelCopyEdit.add(this.m_ButtonCopy);
                panelCopyEdit.add(this.m_ButtonEdit);
                JPanel panelRemove = new JPanel(new GridLayout(1, 2, 0, 0));
                panelRemove.add(this.m_ButtonRemove);
                panelRemove.add(this.m_ButtonRemoveAll);
                this.m_ElementList.clearButtonsPanel();
                this.m_ElementList.addToButtonsPanel(panelAdd);
                this.m_ElementList.addToButtonsPanel(panelCopyEdit);
                this.m_ElementList.addToButtonsPanel(new JLabel(""));
                this.m_ElementList.addToButtonsPanel(panelMove);
                this.m_ElementList.addToButtonsPanel(new JLabel(""));
                this.m_ElementList.addToButtonsPanel(panelRemove);
                this.m_PanelDialogButtons = new JPanel(new GridLayout(1, 2));
                JPanel panelLeft = new JPanel(new FlowLayout(0));
                JPanel panelRight = new JPanel(new FlowLayout(2));
                this.m_PanelDialogButtons.add(panelLeft);
                this.m_PanelDialogButtons.add(panelRight);
                panelLeft.add(this.m_ButtonRevert);
                panelRight.add(this.m_ButtonOK);
                panelRight.add(this.m_ButtonCancel);
                this.add((Component)this.m_PanelDialogButtons, "South");
                this.m_ElementEditor.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        GenericArrayEditor.this.m_ButtonAdd.setIcon(GUIHelper.getIcon("add_modified.gif"));
                        GenericArrayEditor.this.repaint();
                    }
                });
                this.updateButtons();
            }
        }
        if (this.m_ElementEditor == null) {
            this.add((Component)this.m_Label, "Center");
        }
        this.firePropertyChange();
        this.validate();
    }

    @Override
    public void setValue(Object o) {
        this.updateEditorType(o);
    }

    @Override
    public Object getValue() {
        if (this.m_ListModel == null) {
            return null;
        }
        int length = this.m_ListModel.getSize();
        Object result = Array.newInstance(this.m_ElementClass, length);
        for (int i = 0; i < length; ++i) {
            Array.set(result, i, Utils.deepCopy(this.m_ListModel.elementAt(i)));
        }
        return result;
    }

    public PropertyEditor getElementEditor() {
        return this.m_ElementEditor;
    }

    @Override
    public String getJavaInitializationString() {
        return "null";
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        String rep;
        PropertyEditor editor = PropertyEditorManager.findEditor(this.m_ElementClass);
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        if (this.m_ListModel == null || this.m_ListModel.size() == 0) {
            rep = "None";
        } else if (this.m_ListModel.size() == 1) {
            Object obj = this.m_ListModel.get(0);
            if (obj instanceof CustomDisplayStringProvider) {
                rep = ((CustomDisplayStringProvider)obj).toDisplay();
            } else if (editor instanceof CustomStringRepresentationHandler) {
                rep = ((CustomStringRepresentationHandler)((Object)editor)).toCustomStringRepresentation(obj);
            } else {
                rep = obj.getClass().getName();
                int pos = rep.lastIndexOf(46);
                if (pos != -1) {
                    rep = rep.substring(pos + 1);
                }
                if ((pos = rep.lastIndexOf(36)) != -1) {
                    rep = rep.substring(pos + 1);
                }
                AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(obj);
                String optionStr = handler.joinOptions(handler.getOptions(obj));
                rep = rep + " " + optionStr;
                rep = rep.trim();
            }
        } else {
            rep = this.m_ListModel.getSize() + " " + this.m_ElementClass.getName().replaceAll(".*\\.", "");
        }
        gfx.drawString(rep, 2, fm.getAscent() + vpad + 2);
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) {
        throw new IllegalArgumentException(text);
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().removeWindowListener(this.m_WindowAdapter);
            this.getParentDialog().addWindowListener(this.m_WindowAdapter);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().removeWindowListener(this.m_WindowAdapter);
            this.getParentFrame().addWindowListener(this.m_WindowAdapter);
        }
        return this;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    public void addOkListener(ActionListener a) {
        this.m_ButtonOK.addActionListener(a);
    }

    public void addCancelListener(ActionListener a) {
        this.m_ButtonCancel.addActionListener(a);
    }

    public void removeOkListener(ActionListener a) {
        this.m_ButtonOK.removeActionListener(a);
    }

    public void removeCancelListener(ActionListener a) {
        this.m_ButtonCancel.removeActionListener(a);
    }

    public boolean addObject(Object object) {
        boolean result;
        int selected = this.m_ElementList.getSelectedIndex();
        try {
            object = Utils.deepCopy(object);
            if (selected != -1) {
                this.m_ListModel.insertElementAt(object, selected);
            } else {
                this.m_ListModel.addElement(object);
            }
            this.m_ButtonAdd.setIcon(GUIHelper.getIcon("add.gif"));
            this.m_Modified = true;
            result = true;
            this.updateButtons();
        }
        catch (Exception ex) {
            result = false;
            GUIHelper.showErrorMessage(this, "Could not create an object copy/add object");
        }
        return result;
    }

    public boolean addMultipleObjects() {
        if (this.m_ElementEditor instanceof MultiSelectionEditor) {
            Object[] objects = ((MultiSelectionEditor)((Object)this.m_ElementEditor)).getSelectedObjects(this);
            return this.addMultipleObjects(objects);
        }
        return false;
    }

    public boolean addMultipleObjects(Object[] objects) {
        boolean result = true;
        int selected = this.m_ElementList.getSelectedIndex();
        for (int i = 0; i < objects.length; ++i) {
            try {
                Object value = Utils.deepCopy(objects[i]);
                if (selected != -1) {
                    this.m_ListModel.insertElementAt(value, selected + i);
                } else {
                    this.m_ListModel.addElement(value);
                }
                this.m_Modified = true;
                this.updateButtons();
                continue;
            }
            catch (Exception ex) {
                result = false;
                GUIHelper.showErrorMessage(this, "Could not create an object copy/add object");
            }
        }
        return result;
    }

    public void removeAllObjects() {
        this.m_ListModel.clear();
        this.m_Modified = true;
        this.updateButtons();
    }

    protected void removeSelectedObjects() {
        int[] selected = this.m_ElementList.getSelectedIndices();
        if (selected != null) {
            for (int i = selected.length - 1; i >= 0; --i) {
                int current = selected[i];
                this.m_ListModel.removeElementAt(current);
                if (this.m_ListModel.size() > current) {
                    this.m_ElementList.setSelectedIndex(current);
                }
                this.m_Modified = true;
            }
            this.updateButtons();
        }
    }

    protected boolean editSelectedObject() {
        boolean result = false;
        PropertyEditor editor = PropertyEditorManager.findEditor(this.m_ElementClass);
        AbstractGenericObjectEditorHandler handlerElement = AbstractGenericObjectEditorHandler.getHandler(this.m_ElementEditor);
        AbstractGenericObjectEditorHandler handlerGOE = AbstractGenericObjectEditorHandler.getHandler(editor);
        handlerGOE.setClassType(editor, this.m_ElementClass);
        handlerGOE.setCanChangeClassInDialog(editor, handlerElement.getCanChangeClassInDialog(this.m_ElementEditor));
        handlerGOE.setValue(editor, this.m_ElementList.getSelectedValue());
        if (editor.getValue() != null) {
            if (this.m_Dialog == null) {
                this.m_Dialog = GenericObjectEditorDialog.createDialog(this, editor);
                GUIHelper.setSizeAndLocation(this.m_Dialog, this.getLocationOnScreen().y, this.getLocationOnScreen().x);
                this.m_Dialog.setVisible(true);
            } else {
                this.m_Dialog.setEditor(editor);
                this.m_Dialog.setVisible(true);
            }
            if (this.m_Dialog.getResult() == 0) {
                this.m_ListModel.set(this.m_ElementList.getSelectedIndex(), editor.getValue());
                this.m_Modified = true;
                result = true;
                this.updateButtons();
            }
        }
        return result;
    }

    public void firePropertyChange() {
        this.m_Support.firePropertyChange("", null, null);
    }

    protected class EditorListCellRenderer
    implements ListCellRenderer {
        protected Class m_EditorClass;
        protected Class m_ValueClass;

        public EditorListCellRenderer(Class editorClass, Class valueClass) {
            this.m_EditorClass = editorClass;
            this.m_ValueClass = valueClass;
        }

        public Component getListCellRendererComponent(final JList list, Object value, int index, final boolean isSelected, boolean cellHasFocus) {
            try {
                final PropertyEditor e = (PropertyEditor)this.m_EditorClass.newInstance();
                AbstractGenericObjectEditorHandler handlerGOE = AbstractGenericObjectEditorHandler.getHandler(e);
                handlerGOE.setClassType(e, this.m_ValueClass);
                handlerGOE.setCanChangeClassInDialog(e, true);
                handlerGOE.setValue(e, value);
                String display = null;
                if (e instanceof GenericObjectEditor) {
                    display = value instanceof OptionHandler ? AbstractOptionProducer.toString(ArrayProducer.class, (OptionHandler)value) : value.getClass().getName().replaceAll(".*\\.", "");
                    display = display.trim();
                } else if (e instanceof CustomStringRepresentationHandler) {
                    display = ((CustomStringRepresentationHandler)((Object)e)).toCustomStringRepresentation(value);
                } else {
                    AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
                    display = value.getClass().getName().replaceAll(".*\\.", "");
                    display = display + " " + handler.joinOptions(handler.getOptions(value));
                    display = display.trim();
                }
                if (display == null) {
                    return new JPanel(){
                        private static final long serialVersionUID = -3124434678426673334L;

                        @Override
                        public void paintComponent(Graphics g) {
                            Insets i = this.getInsets();
                            Rectangle box = new Rectangle(i.left, i.top, this.getWidth() - i.right, this.getHeight() - i.bottom - 1);
                            g.setColor(isSelected ? list.getSelectionBackground() : list.getBackground());
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            g.setColor(isSelected ? list.getSelectionForeground() : list.getForeground());
                            e.paintValue(g, box);
                        }

                        @Override
                        public Dimension getPreferredSize() {
                            Font f = this.getFont();
                            FontMetrics fm = this.getFontMetrics(f);
                            return new Dimension(0, fm.getHeight() + 2);
                        }
                    };
                }
                JLabel label = new JLabel(display);
                label.setFont(list.getFont().deriveFont(0));
                label.setOpaque(true);
                if (isSelected) {
                    label.setBackground(list.getSelectionBackground());
                } else {
                    label.setBackground(list.getBackground());
                }
                if (isSelected) {
                    label.setForeground(list.getSelectionForeground());
                } else {
                    label.setForeground(list.getForeground());
                }
                return label;
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

