/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.scripting.AbstractScriptingEngine;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;

public class ScriptingEngineManager
implements Serializable {
    private static final long serialVersionUID = 739416057351690903L;
    protected Hashtable<String, AbstractScriptingEngine> m_Engines = new Hashtable();

    protected String getKey(AbstractDatabaseConnection dbcon) {
        return dbcon.getUser() + "@" + dbcon.getURL();
    }

    public boolean has(AbstractDatabaseConnection dbcon) {
        if (dbcon == null) {
            dbcon = DatabaseConnection.getSingleton();
        }
        return this.m_Engines.containsKey(this.getKey(dbcon));
    }

    public AbstractScriptingEngine get(AbstractDatabaseConnection dbcon) {
        if (dbcon == null) {
            dbcon = DatabaseConnection.getSingleton();
        }
        return this.m_Engines.get(this.getKey(dbcon));
    }

    public AbstractScriptingEngine add(AbstractDatabaseConnection dbcon, AbstractScriptingEngine engine) {
        if (dbcon == null) {
            dbcon = DatabaseConnection.getSingleton();
        }
        return this.m_Engines.put(this.getKey(dbcon), engine);
    }

    public Iterator<AbstractScriptingEngine> iterator() {
        return this.m_Engines.values().iterator();
    }

    public String toString() {
        return "Scripting engines: " + this.m_Engines.keySet();
    }
}

