/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.selection;

import adams.core.option.AbstractOption;
import adams.core.option.OptionUtils;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.FieldType;
import adams.db.FieldProvider;
import adams.gui.event.FieldCacheUpdateEvent;
import adams.gui.event.FieldCacheUpdateListener;
import adams.gui.selection.AbstractDatabaseSelectionPanel;
import adams.gui.selection.AbstractFieldCacheManager;
import adams.gui.selection.AbstractTableBasedSelectionPanel;
import adams.gui.selection.FieldCacheTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractSelectDatabaseFieldPanel<T extends AbstractField>
extends AbstractDatabaseSelectionPanel<T>
implements FieldCacheUpdateListener {
    private static final long serialVersionUID = -3858687917199734023L;
    protected static AbstractFieldCacheManager m_CacheManager;
    protected JLabel m_LabelManualFields;
    protected JTextField m_TextManualFields;
    protected JLabel m_LabelDataType;
    protected JComboBox m_ComboBoxDataType;
    protected FieldType m_FieldType;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FieldType = FieldType.FIELD;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_TableData.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (AbstractSelectDatabaseFieldPanel.this.m_TableData.getSelectedRowCount() > 0) {
                    AbstractSelectDatabaseFieldPanel.this.m_TextManualFields.setText("");
                }
            }
        });
        this.m_TextManualFields = new JTextField(15);
        this.m_LabelManualFields = new JLabel();
        this.m_LabelManualFields.setLabelFor(this.m_LabelManualFields);
        this.m_ComboBoxDataType = new JComboBox();
        this.m_ComboBoxDataType.addItem("All");
        for (DataType type : DataType.values()) {
            this.m_ComboBoxDataType.addItem(type.toDisplay());
            if (type != DataType.NUMERIC) continue;
            this.m_ComboBoxDataType.setSelectedIndex(this.m_ComboBoxDataType.getModel().getSize() - 1);
        }
        this.m_ComboBoxDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSelectDatabaseFieldPanel.this.refreshModel();
            }
        });
        this.m_LabelDataType = new JLabel("Data type");
        this.m_LabelDataType.setLabelFor(this.m_ComboBoxDataType);
        this.m_SearchPanel.addToWidgetsPanel(this.m_LabelManualFields);
        this.m_SearchPanel.addToWidgetsPanel(this.m_TextManualFields);
        this.m_SearchPanel.addToWidgetsPanel(this.m_LabelDataType);
        this.m_SearchPanel.addToWidgetsPanel(this.m_ComboBoxDataType);
        this.setMultipleSelection(this.isMultipleSelection());
        this.m_TableData.setOptimalColumnWidth();
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.addCacheListener(this.m_FieldType);
        this.sort();
    }

    protected abstract AbstractFieldCacheManager newFieldCacheManager();

    protected AbstractFieldCacheManager getFieldCacheManager() {
        if (m_CacheManager == null) {
            m_CacheManager = this.newFieldCacheManager();
        }
        return m_CacheManager;
    }

    protected abstract FieldProvider getFieldProvider();

    @Override
    protected AbstractTableBasedSelectionPanel.AbstractSelectionTableModel<T> newTableModel() {
        return new FieldCacheTableModel(null, this.getFieldType(), this.getDataType());
    }

    @Override
    protected abstract Class getItemClass();

    protected abstract T newInstance(String var1, DataType var2);

    public void setFieldType(FieldType value) {
        this.removeCacheListener(this.m_FieldType);
        this.m_FieldType = value;
        this.m_ComboBoxDataType.setVisible(this.m_FieldType != FieldType.PREFIX_FIELD);
        this.m_LabelDataType.setVisible(this.m_ComboBoxDataType.isVisible());
        this.addCacheListener(this.m_FieldType);
        this.refreshModel();
    }

    protected void refreshModel() {
        FieldCacheTableModel model;
        if (this.m_TableDataModel instanceof FieldCacheTableModel && (model = (FieldCacheTableModel)this.m_TableDataModel).getFieldType() == this.getFieldType() && model.getDataType() == this.getDataType()) {
            return;
        }
        this.m_TableDataModel.removeTableModelListener(this.m_TableData);
        this.m_TableDataModel = new FieldCacheTableModel(this.getFieldCacheManager().get(this.getFieldProvider()), this.m_FieldType, this.getDataType());
        this.m_TableData.setModel(this.m_TableDataModel);
        this.m_TableDataModel.addTableModelListener(this.m_TableData);
        this.m_TableData.setOptimalColumnWidth();
    }

    public FieldType getFieldType() {
        return this.m_FieldType;
    }

    @Override
    protected void processMissing(Vector<T> missing) {
        if (this.isMultipleSelection()) {
            String[] list = new String[missing.size()];
            for (int i = 0; i < missing.size(); ++i) {
                list[i] = ((AbstractField)missing.get(i)).toString();
            }
            this.m_TextManualFields.setText(OptionUtils.joinOptions(list));
        } else {
            this.m_TextManualFields.setText(((AbstractField)missing.get(0)).toString());
        }
    }

    @Override
    protected boolean isValidItem(T item) {
        return item != null && ((AbstractField)item).getName() != null && ((AbstractField)item).getName().length() > 0;
    }

    public void setDataType(DataType value) {
        if (this.m_FieldType == FieldType.PREFIX_FIELD) {
            this.m_ComboBoxDataType.setSelectedIndex(0);
        } else if (value == null) {
            this.m_ComboBoxDataType.setSelectedIndex(0);
        } else {
            this.m_ComboBoxDataType.setSelectedItem(value.toDisplay());
        }
    }

    public DataType getDataType() {
        if (this.m_FieldType == FieldType.PREFIX_FIELD) {
            return null;
        }
        if (this.m_ComboBoxDataType == null) {
            return null;
        }
        if (this.m_ComboBoxDataType.getSelectedIndex() <= 0) {
            return null;
        }
        return DataType.valueOf((AbstractOption)null, (String)this.m_ComboBoxDataType.getSelectedItem());
    }

    @Override
    protected T[] getCurrentItems() {
        AbstractField[] result;
        if (this.m_TextManualFields.getText().length() > 0) {
            try {
                String[] fields = this.isMultipleSelection() ? OptionUtils.splitOptions(this.m_TextManualFields.getText()) : new String[]{this.m_TextManualFields.getText()};
                result = (AbstractField[])Array.newInstance(this.getItemClass(), fields.length);
                for (int i = 0; i < fields.length; ++i) {
                    result[i] = this.newInstance(fields[i], this.getDataType());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        } else {
            result = (AbstractField[])super.getCurrentItems();
        }
        return result;
    }

    protected abstract T[] fixClass(T[] var1);

    @Override
    public void setItems(T[] value) {
        super.setItems(value);
        DataType dtype = DataType.NUMERIC;
        for (int i = 0; i < value.length; ++i) {
            if (i == 0) {
                dtype = ((AbstractField)value[i]).getDataType();
                continue;
            }
            if (dtype == ((AbstractField)value[i]).getDataType()) continue;
            dtype = null;
        }
        if (dtype != null) {
            this.setDataType(dtype);
        }
    }

    @Override
    public T[] getItems() {
        return this.fixClass(this.getCurrentItems());
    }

    @Override
    public void setMultipleSelection(boolean value) {
        super.setMultipleSelection(value);
        if (value) {
            this.m_LabelManualFields.setText("Manual fields");
        } else {
            this.m_LabelManualFields.setText("Manual field");
        }
    }

    @Override
    public void refreshIfNecessary() {
        if (!(this.getFieldCacheManager().get(this.getFieldProvider()).isInitialized() && this.getDatabaseConnection().getURL().equals(((FieldCacheTableModel)this.m_TableDataModel).getDatabaseURL()) && this.m_DataDisplayed)) {
            this.refresh();
        }
    }

    @Override
    protected void doRefresh() {
        this.updateTableModel();
    }

    public void sort() {
        this.m_TableData.sort(0);
    }

    @Override
    protected void databaseDisconnected() {
        this.getFieldCacheManager().get(this.getFieldProvider()).clear();
    }

    protected void updateTableModel() {
        int i;
        this.m_TableDataModel.removeTableModelListener(this.m_TableData);
        this.m_TableDataModel = new FieldCacheTableModel(this.getFieldCacheManager().get(this.getFieldProvider()), this.m_FieldType, this.getDataType());
        this.m_TableData.setModel(this.m_TableDataModel);
        this.m_TableData.setOptimalColumnWidth();
        int[] indices = new int[Array.getLength(this.m_Current)];
        for (i = 0; i < indices.length; ++i) {
            indices[i] = this.m_TableDataModel.indexOf((AbstractField)Array.get(this.m_Current, i));
        }
        this.sort();
        if (indices.length > 0) {
            this.m_TableData.getSelectionModel().clearSelection();
            for (i = 0; i < indices.length; ++i) {
                this.m_TableData.getSelectionModel().addSelectionInterval(this.m_TableData.getDisplayRow(indices[i]), this.m_TableData.getDisplayRow(indices[i]));
            }
        }
    }

    @Override
    public void cacheUpdated(FieldCacheUpdateEvent event) {
        this.updateTableModel();
    }

    protected void addCacheListener(FieldType fieldtype) {
        this.getFieldCacheManager().get(this.getFieldProvider()).addCacheListener(this.m_FieldType, this);
    }

    protected void removeCacheListener(FieldType fieldtype) {
        this.getFieldCacheManager().get(this.getFieldProvider()).removeCacheListener(this.m_FieldType, this);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.removeCacheListener(this.m_FieldType);
    }
}

