/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.StatusMessageHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOption;
import adams.data.container.DataContainer;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingEngineHandler;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.VisibilityContainerManager;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public abstract class DataContainerPanel<T extends DataContainer, M extends ContainerManager>
extends PaintablePanel
implements StatusMessageHandler,
ScriptingEngineHandler,
DatabaseConnectionHandler,
DatabaseConnectionChangeListener,
DataChangeListener,
ContainerListManager<M>,
CleanUpHandler,
SendToActionSupporter {
    private static final long serialVersionUID = 5719709547705333418L;
    protected String m_Title;
    protected M m_Manager;
    protected PlotPanel m_PlotPanel;
    protected BasePanel m_PlotWrapperPanel;
    protected HashSet<DataChangeListener> m_DataChangeListeners;
    protected StatusMessageHandler m_StatusMessageHandler;
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected static Hashtable<String, Properties> m_PanelProperties = new Hashtable();

    public DataContainerPanel() {
        this((String)null);
    }

    public DataContainerPanel(String title) {
        this.setTitle(title);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Manager = this.newContainerManager();
        if (this.m_Manager != null) {
            ((ContainerManager)this.m_Manager).addDataChangeListener(this);
        }
        this.m_DataChangeListeners = new HashSet();
        this.m_StatusMessageHandler = null;
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        if (this.m_DatabaseConnection != null) {
            this.m_DatabaseConnection.addChangeListener(this);
        }
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    public synchronized Properties getProperties() {
        Properties result;
        try {
            String props = this.getClass().getName().replaceAll("\\.", "/") + ".props";
            if (m_PanelProperties.containsKey(props)) {
                result = m_PanelProperties.get(props);
            } else {
                result = Properties.read(props);
                m_PanelProperties.put(props, result);
            }
        }
        catch (Exception e) {
            result = new Properties();
        }
        return result;
    }

    protected abstract M newContainerManager();

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = this.getProperties();
        this.setLayout(new BorderLayout());
        this.setTitle(props.getString("Title", this.getTitle()));
        this.m_PlotWrapperPanel = new BasePanel(new BorderLayout());
        this.add((Component)this.m_PlotWrapperPanel, "Center");
        this.m_PlotPanel = new PlotPanel();
        this.m_PlotPanel.addPaintListener(this);
        for (Axis axis : Axis.values()) {
            this.m_PlotPanel.setAxisVisibility(axis, Visibility.valueOf(props.getProperty("Axis." + (Object)((Object)axis) + ".Visibility", Visibility.INVISIBLE.toString())));
            if (this.m_PlotPanel.getAxisVisibility(axis) == Visibility.INVISIBLE) continue;
            this.m_PlotPanel.getAxis(axis).setAxisName(props.getString("Axis." + (Object)((Object)axis) + ".Name", ""));
            this.m_PlotPanel.getAxis(axis).setAxisNameCentered(props.getBoolean("Axis." + (Object)((Object)axis) + ".NameCentered", false));
            this.m_PlotPanel.setAxisWidth(axis, props.getInteger("Axis." + (Object)((Object)axis) + ".Width", 20));
            if (props.getBoolean("Axis." + (Object)((Object)axis) + ".ToolTip", false).booleanValue()) {
                this.m_PlotPanel.addToolTipAxis(axis);
            }
            this.m_PlotPanel.getAxis(axis).setNumTicks(props.getInteger("Axis." + (Object)((Object)axis) + ".NumTicks", 20));
            this.m_PlotPanel.getAxis(axis).setLengthTicks(props.getInteger("Axis." + (Object)((Object)axis) + ".LengthTicks", 4));
            this.m_PlotPanel.getAxis(axis).setNthValueToShow(props.getInteger("Axis." + (Object)((Object)axis) + ".NthValueToShow", 5));
            this.m_PlotPanel.getAxis(axis).setTopMargin(props.getDouble("Axis." + (Object)((Object)axis) + ".TopMargin", 0.0));
            this.m_PlotPanel.getAxis(axis).setShowGridLines(props.getBoolean("Axis." + (Object)((Object)axis) + ".ShowGridLines", true));
            this.m_PlotPanel.getAxis(axis).setShowOnlyMajorGridLines(props.getBoolean("Axis." + (Object)((Object)axis) + ".ShowOnlyMajorGridLines", false));
            this.m_PlotPanel.getAxis(axis).setType(Type.valueOf((AbstractOption)null, props.getString("Axis." + (Object)((Object)axis) + ".Type", "Absolute")));
            this.m_PlotPanel.getAxis(axis).setNumberFormat(props.getString("Axis." + (Object)((Object)axis) + ".NumberFormat", "0.00E0;-0.00E0"));
        }
        this.m_PlotPanel.setForeground(props.getColor("Plot.ForegroundColor", Color.BLACK));
        this.m_PlotPanel.setForeground(props.getColor("Plot.BackgroundColor", Color.WHITE));
        this.m_PlotPanel.setGridColor(props.getColor("Plot.GridColor", new Color(235, 235, 235)));
        this.m_PlotWrapperPanel.add((Component)this.m_PlotPanel, "Center");
    }

    @Override
    public void setContainerManager(M value) {
        ((ContainerManager)this.m_Manager).removeDataChangeListener(this);
        this.m_Manager = value;
        ((ContainerManager)this.m_Manager).addDataChangeListener(this);
    }

    @Override
    public M getContainerManager() {
        return this.m_Manager;
    }

    public abstract Paintlet getContainerPaintlet();

    public void setTitle(String value) {
        this.m_Title = value;
        if (this.m_Title == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.setBorder(BorderFactory.createTitledBorder(this.m_Title));
        }
    }

    public String getTitle() {
        return this.m_Title;
    }

    @Override
    public PlotPanel getPlot() {
        return this.m_PlotPanel;
    }

    public void setForegroundColor(Color value) {
        this.getPlot().setForegroundColor(value);
    }

    public Color getForegroundColor() {
        return this.getPlot().getForegroundColor();
    }

    public void setBackgroundColor(Color value) {
        this.getPlot().setBackgroundColor(value);
    }

    public Color getBackgroundColor() {
        return this.getPlot().getBackgroundColor();
    }

    protected void reset() {
    }

    @Override
    public void dataChanged(DataChangeEvent e) {
        this.update();
    }

    public void setStatusMessageHandler(StatusMessageHandler value) {
        this.m_StatusMessageHandler = value;
    }

    public StatusMessageHandler getStatusMessageHandler() {
        return this.m_StatusMessageHandler;
    }

    @Override
    public void showStatus(String msg) {
        if (this.m_StatusMessageHandler != null) {
            this.m_StatusMessageHandler.showStatus(msg);
        } else {
            System.out.println(msg);
        }
    }

    @Override
    public abstract AbstractScriptingEngine getScriptingEngine();

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DatabaseConnection.removeChangeListener(this);
        this.m_DatabaseConnection = value;
        this.m_DatabaseConnection.addChangeListener(this);
    }

    @Override
    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
        ((ContainerManager)this.getContainerManager()).clear();
        if (e.getType() == DatabaseConnectionChangeEvent.EventType.CONNECT) {
            this.setDatabaseConnection(e.getDatabaseConnection());
        }
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        if (SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, JComponent.class}, cls)) {
            if (this.getContainerManager() instanceof VisibilityContainerManager) {
                return ((VisibilityContainerManager)this.getContainerManager()).countVisible() > 0;
            }
            return ((ContainerManager)this.getContainerManager()).count() > 0;
        }
        return false;
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            result = SendToActionUtils.nextTmpFile(this.getClass().getName().toLowerCase(), "png");
            String formatName = ImageFileChooser.getWriterFormatName(((File)result).getAbsoluteFile());
            if (formatName != null) {
                BufferedImage bi = new BufferedImage(this.getPlot().getWidth(), this.getPlot().getHeight(), 1);
                Graphics g = bi.getGraphics();
                g.setPaintMode();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getPlot().getWidth(), this.getPlot().getHeight());
                this.getPlot().printAll(g);
                try {
                    ImageIO.write((RenderedImage)bi, formatName, ((File)result).getAbsoluteFile());
                }
                catch (Exception e) {
                    System.err.println("Failed to create PNG file '" + result + "':");
                    e.printStackTrace();
                    result = null;
                }
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
            result = this;
        }
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_StatusMessageHandler = null;
        this.m_PlotPanel.removePaintListener(this);
        this.m_DataChangeListeners.clear();
        ((ContainerManager)this.getContainerManager()).clear();
        ((ContainerManager)this.getContainerManager()).removeDataChangeListener(this);
        this.m_DatabaseConnection.removeChangeListener(this);
    }
}

