/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import java.awt.Color;
import java.util.Vector;

public abstract class AbstractColorProvider
extends AbstractOptionHandler
implements ShallowCopySupporter<AbstractColorProvider> {
    private static final long serialVersionUID = 1159553726314921425L;
    public static final int MIN_VALUE = 64;
    protected int m_Index;
    protected boolean m_FirstIteration;
    protected Vector<Color> m_Colors;
    protected Vector<Color> m_DefaultColors;
    protected Vector<Color> m_RecycledColors;
    protected Vector<Color> m_ExcludedColors;
    protected boolean m_AllowDarkening;
    protected boolean m_CheckTooDark;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DefaultColors = new Vector();
        this.m_Colors = new Vector();
        this.m_RecycledColors = new Vector();
        this.m_ExcludedColors = new Vector();
        this.m_AllowDarkening = true;
        this.m_CheckTooDark = true;
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.resetColors();
    }

    public synchronized Color next() {
        if (this.m_DefaultColors.size() == 0) {
            throw new IllegalStateException("No more colors left!");
        }
        Color result = null;
        while (result == null) {
            if (this.m_RecycledColors.size() > 0) {
                result = this.m_RecycledColors.firstElement();
                this.m_RecycledColors.remove(0);
            } else {
                result = this.m_Colors.get(this.m_Index);
                if (!this.m_FirstIteration) {
                    result = result.darker();
                    this.m_Colors.set(this.m_Index, result);
                }
                ++this.m_Index;
                if (this.m_Index >= this.m_Colors.size()) {
                    this.m_Index = 0;
                    if (this.m_AllowDarkening) {
                        this.m_FirstIteration = false;
                    }
                }
            }
            if (!this.m_ExcludedColors.contains(result)) continue;
            result = null;
        }
        if (this.m_CheckTooDark && result.getRed() < 64 && result.getGreen() < 64 && result.getBlue() < 64) {
            this.resetColors();
            result = this.m_Colors.get(this.m_Index);
        }
        if (this.isDebugOn()) {
            this.debug("next color: " + result);
        }
        return result;
    }

    public synchronized void resetColors() {
        this.m_Index = 0;
        this.m_FirstIteration = true;
        this.m_Colors.clear();
        this.m_Colors.addAll(this.m_DefaultColors);
        this.m_RecycledColors.clear();
        this.m_ExcludedColors.clear();
        if (this.isDebugOn()) {
            this.debug("reset of colors");
        }
    }

    public synchronized void recycle(Color c) {
        this.m_RecycledColors.add(c);
    }

    public synchronized void exclude(Color c) {
        this.m_ExcludedColors.add(c);
    }

    @Override
    public AbstractColorProvider shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractColorProvider shallowCopy(boolean expand) {
        return (AbstractColorProvider)OptionUtils.shallowCopy(this, expand);
    }
}

