/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.parser.AbstractSymbolEvaluator;
import adams.parser.booleanexpression.Parser;
import adams.parser.booleanexpression.Scanner;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Vector;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class BooleanExpression
extends AbstractSymbolEvaluator<Boolean> {
    private static final long serialVersionUID = -5923987640355752595L;

    @Override
    public String globalInfo() {
        return "Evaluates boolean expressions.\n\nIt uses the following grammar:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return " expr_list ::= expr_list expr_part | expr_part ;\n expr_part ::= boolexpr ;\n\n boolexpr ::=    ( boolexpr )\n               | true\n               | false\n               | bool ( VARIABLE (must represent a boolean string: true|false) )\n               | numexpr < numexpr\n               | numexpr <= numexpr\n               | numexpr > numexpr\n               | numexpr >= numexpr\n               | numexpr = numexpr\n               | numexpr != numexpr\n               | strexpr < strexpr\n               | strexpr <= strexpr\n               | strexpr > strexpr\n               | strexpr >= strexpr\n               | strexpr = strexpr\n               | strexpr != strexpr\n               | matches ( strexpr , regexp )\n               | ! boolexpr\n               | boolexpr & boolexpr\n               | boolexpr | boolexpr\n               ;\n\n numexpr   ::=   ( numexpr )\n               | NUMBER\n               | -numexpr\n               | constexpr\n               | opexpr\n               | funcexpr\n               ;\n\n strexpr   ::=   substr ( strexpr , start )\n               | substr ( strexpr , start , end )\n               | lowercase ( strexpr )\n               | uppercase ( strexpr )\n               | string\n               | str ( VARIABLE (must represent a string) )\n               ;\n\n constexpr ::=   PI\n               | E\n               ;\n\n opexpr    ::=   numexpr + numexpr\n               | numexpr - numexpr\n               | numexpr * numexpr\n               | numexpr / numexpr\n               | numexpr ^ numexpr (power of)\n               | numexpr % numexpr (modulo)\n               ;\n\n funcexpr ::=    abs ( numexpr )\n               | sqrt ( numexpr )\n               | log ( numexpr )\n               | exp ( numexpr )\n               | sin ( numexpr )\n               | cos ( numexpr )\n               | tan ( numexpr )\n               | rint ( numexpr )\n               | floor ( numexpr )\n               | pow ( numexpr , numexpr )\n               | ceil ( numexpr )\n               | ifelse ( boolexpr , numexpr (if true) , numexpr (if false) )\n               | ifmissing ( variable , numexpr (default value if variable is missing) )\n               | num ( VARIABLE (must represent a number) )\n               | length ( str )\n               ;\n\nNotes:\n- Variables are either all upper case letters (e.g., \"ABC\") or any character   apart from \"]\" enclosed by \"[\" and \"]\" (e.g., \"[Hello World]\").\n- 'start' and 'end' for function 'substr' are indices that start at 1.\n- Index 'end' for function 'substr' is excluded (like Java's 'String.substring(int,int)' method)\n- Line comments start with '#'\n";
    }

    @Override
    protected String getDefaultExpression() {
        return "true";
    }

    @Override
    public String expressionTipText() {
        return "The boolean expression to evaluate (must evaluate to a boolean).";
    }

    @Override
    protected Object initializeSymbol(String name, String value) {
        Double result;
        try {
            result = new Double(value);
        }
        catch (Exception e) {
            result = null;
            this.getSystemErr().println("Failed to parse the value of symbol '" + name + "': " + value);
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    protected Boolean doEvaluate(HashMap symbols) throws Exception {
        return BooleanExpression.evaluate(this.m_Expression, symbols);
    }

    public static boolean evaluate(String expr, HashMap symbols) throws Exception {
        if (expr.equals("true")) {
            return true;
        }
        if (expr.equals("false")) {
            return false;
        }
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setSymbols(symbols);
        parser.parse();
        return parser.getResult();
    }

    public static HashMap reportToSymbols(Report report) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Vector<AbstractField> fields = report.getFields();
        block4: for (AbstractField field : fields) {
            switch (field.getDataType()) {
                case NUMERIC: {
                    result.put(field.toString(), report.getDoubleValue(field));
                    continue block4;
                }
                case BOOLEAN: {
                    result.put(field.toString(), report.getBooleanValue(field));
                    continue block4;
                }
            }
            result.put(field.toString(), "" + report.getValue(field));
        }
        return result;
    }

    public static boolean evaluate(String expr, Report report) throws Exception {
        return BooleanExpression.evaluate(expr, BooleanExpression.reportToSymbols(report));
    }

    public static void main(String[] args) {
        BooleanExpression.runEvaluator(BooleanExpression.class, args);
    }
}

