/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.net.EmailAddress;
import adams.core.net.EmailHelper;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.GenericArrayEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ComposeEmailPanel
extends BasePanel {
    private static final long serialVersionUID = 8667404133601287157L;
    protected JTextField m_TextFrom;
    protected GenericArrayEditorPanel m_GAEPanelTO;
    protected GenericArrayEditorPanel m_GAEPanelCC;
    protected GenericArrayEditorPanel m_GAEPanelBCC;
    protected GenericArrayEditorPanel m_GAEPanelAttachments;
    protected JTextField m_TextSubject;
    protected BaseTextArea m_TextBody;
    protected BaseTextArea m_TextSignature;
    protected JButton m_ButtonSend;
    protected BaseTabbedPane m_TabbedPane;
    protected String m_LastSendResult;
    protected HashSet<ActionListener> m_Listeners;

    protected void initialize() {
        super.initialize();
        this.m_Listeners = new HashSet();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "North");
        ParameterPanel paramPanel = new ParameterPanel();
        this.m_TabbedPane.addTab("Addresses", (Component)paramPanel);
        this.m_TextFrom = new JTextField(40);
        paramPanel.addParameter("_From", (Component)this.m_TextFrom);
        this.m_GAEPanelTO = new GenericArrayEditorPanel((Object)new EmailAddress[0]);
        this.m_GAEPanelTO.setMaxDisplayItems(2);
        paramPanel.addParameter("_To", (Component)this.m_GAEPanelTO);
        this.m_GAEPanelCC = new GenericArrayEditorPanel((Object)new EmailAddress[0]);
        this.m_GAEPanelCC.setMaxDisplayItems(2);
        paramPanel.addParameter("_CC", (Component)this.m_GAEPanelCC);
        this.m_GAEPanelBCC = new GenericArrayEditorPanel((Object)new EmailAddress[0]);
        this.m_GAEPanelBCC.setMaxDisplayItems(2);
        paramPanel.addParameter("_BCC", (Component)this.m_GAEPanelBCC);
        paramPanel = new ParameterPanel();
        this.m_TabbedPane.addTab("Attachments", (Component)paramPanel);
        this.m_GAEPanelAttachments = new GenericArrayEditorPanel((Object)new PlaceholderFile[0]);
        paramPanel.addParameter("_Files", (Component)this.m_GAEPanelAttachments);
        JPanel panel = new JPanel(new BorderLayout());
        this.add(panel, "Center");
        this.m_TextSubject = new JTextField(40);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel("Subject");
        label.setLabelFor(this.m_TextSubject);
        label.setDisplayedMnemonic('u');
        panel2.add(label);
        panel2.add(this.m_TextSubject);
        panel.add((Component)panel2, "North");
        JPanel panelBodyFooter = new JPanel(new BorderLayout());
        panel.add((Component)panelBodyFooter, "Center");
        this.m_TextBody = new BaseTextArea();
        this.m_TextBody.setFont(GUIHelper.getMonospacedFont());
        panelBodyFooter.add((Component)new BaseScrollPane((Component)this.m_TextBody), "Center");
        this.m_TextSignature = new BaseTextArea(4, 80);
        this.m_TextSignature.setFont(GUIHelper.getMonospacedFont());
        panelBodyFooter.add((Component)new BaseScrollPane((Component)this.m_TextSignature), "South");
        panel2 = new JPanel(new FlowLayout(2));
        panel.add((Component)panel2, "South");
        this.m_ButtonSend = new JButton("Send");
        this.m_ButtonSend.setMnemonic('S');
        this.m_ButtonSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = ComposeEmailPanel.this.send();
                if (msg != null) {
                    GUIHelper.showErrorMessage((Component)((Object)ComposeEmailPanel.this), (String)("Failed to send email:\n" + msg));
                }
            }
        });
        panel2.add(this.m_ButtonSend);
        if (!EmailHelper.isEnabled()) {
            this.m_ButtonSend.setText("Send - Check email setup!");
            this.m_ButtonSend.setEnabled(false);
        }
        this.clear();
    }

    public void clear() {
        this.setFrom(new EmailAddress(EmailHelper.getDefaultFromAddress()));
        this.setTO(null);
        this.setCC(null);
        this.setBCC(null);
        this.setAttachments(null);
        this.setSubject("");
        this.setBody("");
        this.setSignature(Utils.unbackQuoteChars((String)EmailHelper.getDefaultSignature()));
        this.grabFocus();
        this.m_LastSendResult = null;
    }

    public void setFrom(EmailAddress value) {
        this.m_TextFrom.setText(value.getValue());
    }

    public EmailAddress getFrom() {
        return new EmailAddress(this.m_TextFrom.getText());
    }

    public void setTO(EmailAddress[] value) {
        if (value == null) {
            value = new EmailAddress[]{};
        }
        this.m_GAEPanelTO.setCurrent((Object)value);
    }

    public EmailAddress[] getTO() {
        return (EmailAddress[])this.m_GAEPanelTO.getCurrent();
    }

    public void setCC(EmailAddress[] value) {
        if (value == null) {
            value = new EmailAddress[]{};
        }
        this.m_GAEPanelCC.setCurrent((Object)value);
    }

    public EmailAddress[] getCC() {
        return (EmailAddress[])this.m_GAEPanelCC.getCurrent();
    }

    public void setBCC(EmailAddress[] value) {
        if (value == null) {
            value = new EmailAddress[]{};
        }
        this.m_GAEPanelBCC.setCurrent((Object)value);
    }

    public EmailAddress[] getBCC() {
        return (EmailAddress[])this.m_GAEPanelBCC.getCurrent();
    }

    public void setAttachments(PlaceholderFile[] value) {
        if (value == null) {
            value = new PlaceholderFile[]{};
        }
        this.m_GAEPanelAttachments.setCurrent((Object)value);
    }

    public PlaceholderFile[] getAttachments() {
        return (PlaceholderFile[])this.m_GAEPanelAttachments.getCurrent();
    }

    public void setSubject(String value) {
        this.m_TextSubject.setText(value);
    }

    public String getSubject() {
        return this.m_TextSubject.getText();
    }

    public void setBody(String value) {
        this.m_TextBody.setText(value);
    }

    public String getBody() {
        return this.m_TextBody.getText();
    }

    public void setSignature(String value) {
        this.m_TextSignature.setText(value);
    }

    public String getSignature() {
        return this.m_TextSignature.getText();
    }

    protected String check() {
        if (this.m_TextFrom.getText().trim().length() == 0) {
            return "No sender!";
        }
        int recipients = 0;
        recipients += ((EmailAddress[])this.m_GAEPanelTO.getCurrent()).length;
        recipients += ((EmailAddress[])this.m_GAEPanelCC.getCurrent()).length;
        if ((recipients += ((EmailAddress[])this.m_GAEPanelBCC.getCurrent()).length) == 0) {
            return "No recipients added!";
        }
        if (this.m_TextSubject.getText().trim().length() == 0) {
            return "No subject entered!";
        }
        if (this.m_TextBody.getText().trim().length() == 0) {
            return "No message body entered!";
        }
        PlaceholderFile[] files = (PlaceholderFile[])this.m_GAEPanelAttachments.getCurrent();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                return "File #" + (i + 1) + " points to a directory:\n" + files[i];
            }
            if (files[i].exists()) continue;
            return "File #" + (i + 1) + " does not exist:\n" + files[i];
        }
        return null;
    }

    protected String[] getEmailAddresses(GenericArrayEditorPanel panel) {
        String[] result = null;
        EmailAddress[] addr = (EmailAddress[])panel.getCurrent();
        if (addr.length > 0) {
            result = new String[addr.length];
            for (int i = 0; i < addr.length; ++i) {
                result[i] = addr[i].getValue();
            }
        }
        return result;
    }

    public String send() {
        this.m_LastSendResult = this.check();
        if (this.m_LastSendResult == null) {
            try {
                EmailHelper.sendMail(this.m_TextFrom.getText(), this.getEmailAddresses(this.m_GAEPanelTO), this.getEmailAddresses(this.m_GAEPanelCC), this.getEmailAddresses(this.m_GAEPanelBCC), this.m_TextSubject.getText(), EmailHelper.combine(this.m_TextBody.getText(), this.m_TextSignature.getText()), (File[])((PlaceholderFile[])this.m_GAEPanelAttachments.getCurrent()));
            }
            catch (Exception e) {
                String msg = "Failed to send email: ";
                System.err.println(msg);
                e.printStackTrace();
                this.m_LastSendResult = msg + e;
            }
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ComposeEmailPanel.this.notifySendListeners();
            }
        };
        SwingUtilities.invokeLater(run);
        return this.m_LastSendResult;
    }

    public String getLastSendResult() {
        return this.m_LastSendResult;
    }

    public void addSendListener(ActionListener l) {
        this.m_Listeners.add(l);
    }

    public void removeSendListener(ActionListener l) {
        this.m_Listeners.remove(l);
    }

    protected void notifySendListeners() {
        ActionEvent event = new ActionEvent((Object)this, -1, "send");
        for (ActionListener l : this.m_Listeners) {
            l.actionPerformed(event);
        }
    }

    public void grabFocus() {
        this.m_TextBody.grabFocus();
    }
}

