/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.WekaEvaluationContainer;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractGlobalPHMMClassifierEvaluator;
import weka.classifiers.evaluation.output.prediction.Null;
import weka.classifiers.meta.IterativeHMMClassifier;
import weka.core.Instances;
import weka.utils.AbstractIterativeEvaluation;

public abstract class AbstractPHMMIterativeEvaluation<T extends IterativeHMMClassifier, E extends AbstractIterativeEvaluation>
extends AbstractGlobalPHMMClassifierEvaluator<T>
implements ProvenanceSupporter {
    private static final long serialVersionUID = 7476193204422224840L;
    protected int m_Folds;
    protected int m_NumIterations;
    protected int m_IterationStepSize;
    protected transient AbstractIterativeEvaluation.EvaluationIterator m_Iterator;
    protected AbstractIterativeEvaluation.EvaluationStep m_CurrentStep;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("folds", "folds", (Object)10, (Number)-1, null);
        this.m_OptionManager.add("num-iterations", "numIterations", (Object)1, (Number)1, null);
        this.m_OptionManager.add("iteration-step-size", "iterationStepSize", (Object)1, (Number)1, null);
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("classifier");
        String result = variable != null ? variable : this.m_Classifier.toString();
        result = result + ", ";
        variable = this.getOptionManager().getVariableForProperty("folds");
        result = variable != null ? result + variable : result + this.m_Folds;
        result = result + " folds";
        result = result + ", ";
        variable = this.getOptionManager().getVariableForProperty("numIterations");
        result = variable != null ? result + variable : result + this.m_NumIterations;
        result = result + " iterations";
        result = result + "/";
        variable = this.getOptionManager().getVariableForProperty("iterationStepSize");
        result = variable != null ? result + variable : result + this.m_IterationStepSize;
        return result;
    }

    @Override
    public String classifierTipText() {
        return "The global PHMM classifier actor to evaluate on the input data.";
    }

    public void setFolds(int value) {
        if (value == -1 || value >= 2) {
            this.m_Folds = value;
            this.reset();
        } else {
            this.getSystemErr().println("Number of folds must be >=2 or -1 for LOOCV, provided: " + value);
        }
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String foldsTipText() {
        return "The number of folds to use in the cross-validation; use -1 for leave-one-out cross-validation (LOOCV).";
    }

    public void setNumIterations(int value) {
        this.m_NumIterations = value;
        this.reset();
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String numIterationsTipText() {
        return "The number of iterations to perform.";
    }

    public void setIterationStepSize(int value) {
        this.m_IterationStepSize = value;
        this.reset();
    }

    public int getIterationStepSize() {
        return this.m_IterationStepSize;
    }

    public String iterationStepSizeTipText() {
        return "The step size for the iterations.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    protected abstract E newEvaluation();

    protected String doExecute() {
        String result = null;
        try {
            IterativeHMMClassifier cls = (IterativeHMMClassifier)this.getClassifierInstance();
            if (cls == null) {
                throw new IllegalStateException("Classifier '" + this.getClassifier() + "' not found!");
            }
            Instances data = (Instances)this.m_InputToken.getPayload();
            int folds = this.m_Folds;
            if (folds == -1) {
                folds = data.numInstances();
            }
            E eval = this.newEvaluation();
            eval.setOutput(this.m_Output);
            eval.setClassifier(cls);
            eval.setFolds(folds);
            eval.setUpperBoundIterations(this.m_NumIterations);
            eval.setIterationSteps(this.m_IterationStepSize);
            eval.setTrainingSet(data);
            this.m_Iterator = eval.iterator();
            this.m_CurrentStep = this.m_Iterator.next();
        }
        catch (Exception e) {
            result = this.handleException("Failed to evaluate: ", e);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_CurrentStep != null || this.m_Iterator != null && this.m_Iterator.hasNext();
    }

    public Token output() {
        Token result = null;
        if (this.m_CurrentStep == null && this.m_Iterator != null && this.m_Iterator.hasNext()) {
            this.m_CurrentStep = this.m_Iterator.next();
        }
        if (this.m_CurrentStep != null) {
            result = this.m_Output instanceof Null ? new Token((Object)new WekaEvaluationContainer(this.m_CurrentStep.getEvaluation())) : new Token((Object)this.m_Output.getBuffer().toString());
            if (this.m_OutputToken != null) {
                this.updateProvenance((ProvenanceContainer)result);
            }
            this.m_CurrentStep = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution() {
        if (this.m_Iterator != null) {
            this.m_Iterator.stop();
            while (!this.m_Iterator.isStopped()) {
                try {
                    AbstractPHMMIterativeEvaluation abstractPHMMIterativeEvaluation = this;
                    synchronized (abstractPHMMIterativeEvaluation) {
                        ((Object)((Object)this)).wait(100L);
                    }
                }
                catch (Exception exception) {
                }
            }
            this.m_Iterator = null;
        }
        super.stopExecution();
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.EVALUATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, ((Token)cont).getPayload().getClass()));
        }
    }
}

