/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.statistics.ProbabilityDistribution;

public class UniformDistribution
extends ProbabilityDistribution {
    private final double min;
    private final double max;
    private final double range;

    public UniformDistribution(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.range = d2 - d;
    }

    public double probability(double d) {
        return d >= this.min && d <= this.max ? 1.0 / this.range : 0.0;
    }

    public double cumulative(double d) {
        if (d < this.min) {
            return 0.0;
        }
        if (d <= this.max) {
            return (d - this.min) / this.range;
        }
        return 1.0;
    }

    public double inverse(double d) {
        return d * this.range + this.min;
    }
}

