/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2;

import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileFilter;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileSystemView;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileView;
import com.googlecode.vfsjfilechooser2.plaf.AbstractVFSFileChooserUI;
import com.googlecode.vfsjfilechooser2.plaf.metal.MetalVFSFileChooserUI;
import com.googlecode.vfsjfilechooser2.utils.DefaultFileObjectConverter;
import com.googlecode.vfsjfilechooser2.utils.FileObjectConverter;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.vfs2.FileObject;

public class VFSJFileChooser
extends JComponent
implements Accessible {
    private static final Frame SHARED_FRAME = new Frame();
    private static final FileObject[] EMPTY_FILEOBJECT_ARRAY = new FileObject[0];
    private String dialogTitle = null;
    private String approveButtonText = null;
    private String approveButtonToolTipText = null;
    private int approveButtonMnemonic = 0;
    private List<AbstractVFSFileFilter> filters = new CopyOnWriteArrayList<AbstractVFSFileFilter>();
    private JDialog dialog = null;
    private DIALOG_TYPE dialogType = DIALOG_TYPE.OPEN;
    private RETURN_TYPE returnValue = RETURN_TYPE.ERROR;
    private JComponent accessory = null;
    private AbstractVFSFileView fileView = null;
    private transient AbstractVFSFileView uiFileView = null;
    private boolean controlsShown = true;
    private boolean useFileHiding = true;
    private transient PropertyChangeListener showFilesListener = null;
    private SELECTION_MODE fileSelectionMode = SELECTION_MODE.FILES_ONLY;
    private boolean multiSelectionEnabled = false;
    private boolean useAcceptAllFileFilter = true;
    private boolean dragEnabled = false;
    private AbstractVFSFileFilter fileFilter = null;
    private AbstractVFSFileSystemView fileSystemView = null;
    private FileObject currentDirectory = null;
    private FileObject selectedFile = null;
    private FileObject[] selectedFiles;
    protected FileObjectConverter fileObjectConverter = new DefaultFileObjectConverter();
    protected AccessibleContext m_accessibleContext = null;
    private MetalVFSFileChooserUI defaultUI;

    public VFSJFileChooser() {
        this((FileObject)null, (AbstractVFSFileSystemView)null);
    }

    public VFSJFileChooser(String currentDirectoryPath) {
        this(currentDirectoryPath, (AbstractVFSFileSystemView)null);
    }

    public VFSJFileChooser(File currentDirectory) {
        this(VFSUtils.toFileObject(currentDirectory));
    }

    public VFSJFileChooser(FileObject currentDirectory) {
        this(currentDirectory, (AbstractVFSFileSystemView)null);
    }

    public VFSJFileChooser(AbstractVFSFileSystemView fsv) {
        this((FileObject)null, fsv);
    }

    public VFSJFileChooser(FileObject currentDirectory, AbstractVFSFileSystemView fsv) {
        this.setup(fsv);
        this.setCurrentDirectoryObject(currentDirectory);
    }

    public VFSJFileChooser(String currentDirectoryPath, AbstractVFSFileSystemView fsv) {
        this.setup(fsv);
        if (currentDirectoryPath == null) {
            this.setCurrentDirectory(null);
        } else {
            this.setCurrentDirectoryObject(this.fileSystemView.createFileObject(currentDirectoryPath));
        }
    }

    public JPanel getNavigationButtonsPanel() {
        return this.defaultUI.getNavigationButtonsPanel();
    }

    public JButton getUpFolderButton() {
        return this.defaultUI.getUpFolderButton();
    }

    public JButton getHomeFolderButton() {
        return this.defaultUI.getHomeFolderButton();
    }

    public JButton getNewFolderButton() {
        return this.defaultUI.getNewFolderButton();
    }

    protected void setup(AbstractVFSFileSystemView view) {
        this.installShowFilesListener();
        if (view == null) {
            view = AbstractVFSFileSystemView.getFileSystemView();
        }
        this.setFileSystemView(view);
        this.updateUI();
        if (this.isAcceptAllFileFilterUsed()) {
            this.setFileFilter(this.getAcceptAllFileFilter());
        }
        this.enableEvents(16L);
    }

    private void installShowFilesListener() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Object showHiddenProperty = tk.getDesktopProperty("awt.file.showHiddenFiles");
        if (showHiddenProperty instanceof Boolean) {
            this.useFileHiding = (Boolean)showHiddenProperty == false;
            this.showFilesListener = new WeakPCL(this);
            tk.addPropertyChangeListener("awt.file.showHiddenFiles", this.showFilesListener);
        }
    }

    public void setDragEnabled(boolean b) {
        if (b && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = b;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public File getSelectedFile() {
        return this.fileObjectConverter.convertFileObject(this.selectedFile);
    }

    public FileObject getSelectedFileObject() {
        return this.selectedFile;
    }

    public void setSelectedFile(File file) {
        this.setSelectedFileObject(VFSUtils.toFileObject(file));
    }

    public void setSelectedFileObject(FileObject file) {
        FileObject oldValue = this.selectedFile;
        this.selectedFile = file;
        if (this.selectedFile != null) {
            if (!this.getFileSystemView().isParent(this.getCurrentDirectoryObject(), this.selectedFile)) {
                this.setCurrentDirectoryObject(VFSUtils.getParentDirectory(this.selectedFile));
            }
            if (!this.isMultiSelectionEnabled() || this.selectedFiles == null || this.selectedFiles.length == 1) {
                this.ensureFileIsVisible(this.selectedFile);
            }
        }
        this.firePropertyChange("SelectedFileChangedProperty", oldValue, this.selectedFile);
    }

    public File[] getSelectedFiles() {
        FileObject[] objects = this.getSelectedFileObjects();
        File[] files = new File[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            files[i] = this.fileObjectConverter.convertFileObject(objects[i]);
        }
        return files;
    }

    public FileObject[] getSelectedFileObjects() {
        if (this.selectedFiles == null) {
            return new FileObject[0];
        }
        return (FileObject[])this.selectedFiles.clone();
    }

    public void setSelectedFiles(File[] selectedFiles) {
        FileObject[] objects = new FileObject[selectedFiles.length];
        for (int i = 0; i < selectedFiles.length; ++i) {
            objects[i] = VFSUtils.toFileObject(selectedFiles[i]);
        }
        this.setSelectedFileObjects(objects);
    }

    public void setSelectedFileObjects(FileObject[] selectedFiles) {
        FileObject[] oldValue = this.selectedFiles;
        if (selectedFiles == null || selectedFiles.length == 0) {
            selectedFiles = null;
            this.selectedFiles = null;
            this.setSelectedFileObject(null);
        } else {
            this.selectedFiles = (FileObject[])selectedFiles.clone();
            this.setSelectedFileObject(this.selectedFiles[0]);
        }
        this.firePropertyChange("SelectedFilesChangedProperty", oldValue, selectedFiles);
    }

    public File getCurrentDirectory() {
        return this.fileObjectConverter.convertFileObject(this.currentDirectory);
    }

    public FileObject getCurrentDirectoryObject() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File dir) {
        this.setCurrentDirectoryObject(VFSUtils.toFileObject(dir));
    }

    public void setCurrentDirectoryObject(FileObject dir) {
        FileObject oldValue = this.currentDirectory;
        if (dir != null && !VFSUtils.exists(dir)) {
            dir = this.currentDirectory;
        }
        if (dir == null) {
            dir = this.getFileSystemView().getDefaultDirectory();
        }
        if (this.currentDirectory != null && this.currentDirectory.equals(dir)) {
            return;
        }
        FileObject prev = null;
        while (!this.isTraversable(dir) && prev != dir) {
            prev = dir;
            dir = this.getFileSystemView().getParentDirectory(dir);
        }
        this.currentDirectory = dir;
        this.firePropertyChange("directoryChanged", oldValue, this.currentDirectory);
    }

    public void changeToParentDirectory() {
        this.selectedFile = null;
        FileObject oldValue = this.getCurrentDirectoryObject();
        this.setCurrentDirectoryObject(this.getFileSystemView().getParentDirectory(oldValue));
    }

    public void rescanCurrentDirectory() {
        this.getUI().rescanCurrentDirectory(this);
    }

    public void ensureFileIsVisible(FileObject f) {
        this.getUI().ensureFileIsVisible(this, f);
    }

    public RETURN_TYPE showOpenDialog(Component parent) throws HeadlessException {
        this.setDialogType(DIALOG_TYPE.OPEN);
        return this.showDialog(parent, null);
    }

    public RETURN_TYPE showSaveDialog(Component parent) throws HeadlessException {
        this.setDialogType(DIALOG_TYPE.SAVE);
        return this.showDialog(parent, null);
    }

    public RETURN_TYPE showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (approveButtonText != null) {
            this.setApproveButtonText(approveButtonText);
            this.setDialogType(DIALOG_TYPE.CUSTOM);
        }
        this.dialog = this.createDialog(parent);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VFSJFileChooser.this.returnValue = RETURN_TYPE.CANCEL;
            }
        });
        this.returnValue = RETURN_TYPE.ERROR;
        this.rescanCurrentDirectory();
        this.dialog.setVisible(true);
        this.firePropertyChange("JFileChooserDialogIsClosingProperty", this.dialog, null);
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }

    protected JDialog createDialog(Component parent) throws HeadlessException {
        boolean supportsWindowDecorations;
        String title = this.getUI().getDialogTitle(this);
        this.putClientProperty("AccessibleDescription", title);
        Window window = null;
        try {
            window = SwingUtilities.getWindowAncestor(parent);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (window == null) {
            window = parent instanceof Window ? (Window)parent : SHARED_FRAME;
            this.dialog = new JDialog((Frame)window, title, true);
        } else {
            this.dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        }
        this.dialog.setComponentOrientation(this.getComponentOrientation());
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.dialog.getRootPane().setWindowDecorationStyle(6);
        }
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        return this.dialog;
    }

    public boolean getControlButtonsAreShown() {
        return this.controlsShown;
    }

    public void setControlButtonsAreShown(boolean b) {
        if (this.controlsShown == b) {
            return;
        }
        boolean oldValue = this.controlsShown;
        this.controlsShown = b;
        this.firePropertyChange("ControlButtonsAreShownChangedProperty", oldValue, this.controlsShown);
    }

    public DIALOG_TYPE getDialogType() {
        return this.dialogType;
    }

    public void setDialogType(DIALOG_TYPE dialogType) {
        if (this.dialogType == dialogType) {
            return;
        }
        if (dialogType != DIALOG_TYPE.OPEN && dialogType != DIALOG_TYPE.SAVE && dialogType != DIALOG_TYPE.CUSTOM) {
            throw new IllegalArgumentException("Incorrect Dialog Type: " + (Object)((Object)dialogType));
        }
        DIALOG_TYPE oldValue = this.dialogType;
        this.dialogType = dialogType;
        if (dialogType == DIALOG_TYPE.OPEN || dialogType == DIALOG_TYPE.SAVE) {
            this.setApproveButtonText(null);
        }
        this.firePropertyChange("DialogTypeChangedProperty", (Object)oldValue, (Object)dialogType);
    }

    public void setDialogTitle(String dialogTitle) {
        String oldValue = this.dialogTitle;
        this.dialogTitle = dialogTitle;
        if (this.dialog != null) {
            this.dialog.setTitle(dialogTitle);
        }
        this.firePropertyChange("DialogTitleChangedProperty", oldValue, dialogTitle);
    }

    public String getDialogTitle() {
        return this.dialogTitle;
    }

    public void setApproveButtonToolTipText(String toolTipText) {
        if (this.approveButtonToolTipText == toolTipText || this.approveButtonToolTipText != null && this.approveButtonToolTipText.equals(toolTipText)) {
            return;
        }
        String oldValue = this.approveButtonToolTipText;
        this.approveButtonToolTipText = toolTipText;
        this.firePropertyChange("ApproveButtonToolTipTextChangedProperty", oldValue, this.approveButtonToolTipText);
    }

    public String getApproveButtonToolTipText() {
        return this.approveButtonToolTipText;
    }

    public int getApproveButtonMnemonic() {
        return this.approveButtonMnemonic;
    }

    public void setApproveButtonMnemonic(int mnemonic) {
        if (this.approveButtonMnemonic == mnemonic) {
            return;
        }
        int oldValue = this.approveButtonMnemonic;
        this.approveButtonMnemonic = mnemonic;
        this.firePropertyChange("ApproveButtonMnemonicChangedProperty", oldValue, this.approveButtonMnemonic);
    }

    public void setApproveButtonMnemonic(char mnemonic) {
        int vk = mnemonic;
        if (vk >= 97 && vk <= 122) {
            vk -= 32;
        }
        this.setApproveButtonMnemonic(vk);
    }

    public void setApproveButtonText(String approveButtonText) {
        if (this.approveButtonText == approveButtonText || this.approveButtonText != null && this.approveButtonText.equals(approveButtonText)) {
            return;
        }
        String oldValue = this.approveButtonText;
        this.approveButtonText = approveButtonText;
        this.firePropertyChange("ApproveButtonTextChangedProperty", oldValue, approveButtonText);
    }

    public String getApproveButtonText() {
        return this.approveButtonText;
    }

    public AbstractVFSFileFilter[] getChoosableFileFilters() {
        return this.filters.toArray(new AbstractVFSFileFilter[this.filters.size()]);
    }

    public void addChoosableFileFilter(AbstractVFSFileFilter filter) {
        if (filter != null && !this.filters.contains(filter)) {
            AbstractVFSFileFilter[] oldValue = this.getChoosableFileFilters();
            this.filters.add(filter);
            this.firePropertyChange("ChoosableFileFilterChangedProperty", oldValue, this.getChoosableFileFilters());
            if (this.fileFilter == null && this.filters.size() == 1) {
                this.setFileFilter(filter);
            }
        }
    }

    public boolean removeChoosableFileFilter(AbstractVFSFileFilter f) {
        if (this.filters.contains(f)) {
            if (this.getFileFilter() == f) {
                this.setFileFilter(null);
            }
            AbstractVFSFileFilter[] oldValue = this.getChoosableFileFilters();
            this.filters.remove(f);
            this.firePropertyChange("ChoosableFileFilterChangedProperty", oldValue, this.getChoosableFileFilters());
            return true;
        }
        return false;
    }

    public void resetChoosableFileFilters() {
        AbstractVFSFileFilter[] oldValue = this.getChoosableFileFilters();
        this.setFileFilter(null);
        this.filters.clear();
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.firePropertyChange("ChoosableFileFilterChangedProperty", oldValue, this.getChoosableFileFilters());
    }

    public AbstractVFSFileFilter getAcceptAllFileFilter() {
        AbstractVFSFileFilter filter = null;
        if (this.getUI() != null) {
            filter = this.getUI().getAcceptAllFileFilter(this);
        }
        return filter;
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.useAcceptAllFileFilter;
    }

    public void setAcceptAllFileFilterUsed(boolean b) {
        boolean oldValue = this.useAcceptAllFileFilter;
        this.useAcceptAllFileFilter = b;
        if (!b) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        } else {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        this.firePropertyChange("acceptAllFileFilterUsedChanged", oldValue, this.useAcceptAllFileFilter);
    }

    public JComponent getAccessory() {
        return this.accessory;
    }

    public void setAccessory(JComponent newAccessory) {
        JComponent oldValue = this.accessory;
        this.accessory = newAccessory;
        this.firePropertyChange("AccessoryChangedProperty", oldValue, this.accessory);
    }

    public void setFileSelectionMode(SELECTION_MODE mode) {
        if (this.fileSelectionMode == mode) {
            return;
        }
        if (mode != SELECTION_MODE.FILES_ONLY && mode != SELECTION_MODE.DIRECTORIES_ONLY && mode != SELECTION_MODE.FILES_AND_DIRECTORIES) {
            throw new IllegalArgumentException("Incorrect Mode for file selection: " + (Object)((Object)mode));
        }
        SELECTION_MODE oldValue = this.fileSelectionMode;
        this.fileSelectionMode = mode;
        this.firePropertyChange("fileSelectionChanged", (Object)oldValue, (Object)this.fileSelectionMode);
    }

    public SELECTION_MODE getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public boolean isFileSelectionEnabled() {
        return this.fileSelectionMode == SELECTION_MODE.FILES_ONLY || this.fileSelectionMode == SELECTION_MODE.FILES_AND_DIRECTORIES;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.fileSelectionMode == SELECTION_MODE.DIRECTORIES_ONLY || this.fileSelectionMode == SELECTION_MODE.FILES_AND_DIRECTORIES;
    }

    public void setMultiSelectionEnabled(boolean b) {
        if (this.multiSelectionEnabled == b) {
            return;
        }
        boolean oldValue = this.multiSelectionEnabled;
        this.multiSelectionEnabled = b;
        this.firePropertyChange("MultiSelectionEnabledChangedProperty", oldValue, this.multiSelectionEnabled);
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public boolean isFileHidingEnabled() {
        return this.useFileHiding;
    }

    public void setFileHidingEnabled(boolean b) {
        if (this.showFilesListener != null) {
            Toolkit.getDefaultToolkit().removePropertyChangeListener("awt.file.showHiddenFiles", this.showFilesListener);
            this.showFilesListener = null;
        }
        boolean oldValue = this.useFileHiding;
        this.useFileHiding = b;
        this.firePropertyChange("FileHidingChanged", oldValue, this.useFileHiding);
    }

    public void setFileFilter(AbstractVFSFileFilter filter) {
        AbstractVFSFileFilter oldValue = this.fileFilter;
        this.fileFilter = filter;
        if (filter != null) {
            if (this.isMultiSelectionEnabled() && this.selectedFiles != null && this.selectedFiles.length > 0) {
                ArrayList<FileObject> fList = new ArrayList<FileObject>(this.selectedFiles.length);
                boolean failed = false;
                for (FileObject aSelectedFile : this.selectedFiles) {
                    if (filter.accept(aSelectedFile)) {
                        fList.add(aSelectedFile);
                        continue;
                    }
                    failed = true;
                }
                if (failed) {
                    this.setSelectedFileObjects(EMPTY_FILEOBJECT_ARRAY);
                }
            } else if (this.selectedFile != null && !filter.accept(this.selectedFile)) {
                this.setSelectedFileObject(null);
            }
        }
        this.firePropertyChange("fileFilterChanged", oldValue, this.fileFilter);
    }

    public AbstractVFSFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileView(AbstractVFSFileView fileView) {
        AbstractVFSFileView oldValue = this.fileView;
        this.fileView = fileView;
        this.firePropertyChange("fileViewChanged", oldValue, fileView);
    }

    public AbstractVFSFileView getFileView() {
        return this.fileView;
    }

    public void setFileObjectConverter(FileObjectConverter value) {
        this.fileObjectConverter = value;
    }

    public FileObjectConverter getFileObjectConverter() {
        return this.fileObjectConverter;
    }

    public String getName(FileObject fileObject) {
        String filename = null;
        if (fileObject != null) {
            if (this.getFileView() != null) {
                filename = this.getFileView().getName(fileObject);
            }
            if (filename == null && this.uiFileView != null) {
                filename = this.uiFileView.getName(fileObject);
            }
        }
        return filename;
    }

    public String getDescription(FileObject fileObject) {
        String description = null;
        if (fileObject != null) {
            if (this.getFileView() != null) {
                description = this.getFileView().getDescription(fileObject);
            }
            if (description == null && this.uiFileView != null) {
                description = this.uiFileView.getDescription(fileObject);
            }
        }
        return description;
    }

    public String getTypeDescription(FileObject fileObject) {
        String typeDescription = null;
        if (fileObject != null) {
            if (this.getFileView() != null) {
                typeDescription = this.getFileView().getTypeDescription(fileObject);
            }
            if (typeDescription == null && this.uiFileView != null) {
                typeDescription = this.uiFileView.getTypeDescription(fileObject);
            }
        }
        return typeDescription;
    }

    public Icon getIcon(FileObject fileObject) {
        Icon icon = null;
        if (fileObject != null) {
            if (this.getFileView() != null) {
                icon = this.getFileView().getIcon(fileObject);
            }
            if (icon == null && this.uiFileView != null) {
                icon = this.uiFileView.getIcon(fileObject);
            }
        }
        return icon;
    }

    public boolean isTraversable(FileObject fileObject) {
        Boolean traversable = null;
        if (fileObject != null) {
            if (this.getFileView() != null) {
                traversable = this.getFileView().isTraversable(fileObject);
            }
            if (traversable == null && this.uiFileView != null) {
                traversable = this.uiFileView.isTraversable(fileObject);
            }
            if (traversable == null) {
                traversable = this.getFileSystemView().isTraversable(fileObject);
            }
        }
        return traversable != null && traversable != false;
    }

    public boolean accept(FileObject fileObject) {
        boolean shown = true;
        if (fileObject != null && this.fileFilter != null) {
            shown = this.fileFilter.accept(fileObject);
        }
        return shown;
    }

    public void setFileSystemView(AbstractVFSFileSystemView fsv) {
        AbstractVFSFileSystemView oldValue = this.fileSystemView;
        this.fileSystemView = fsv;
        this.firePropertyChange("FileSystemViewChanged", oldValue, this.fileSystemView);
    }

    public AbstractVFSFileSystemView getFileSystemView() {
        return this.fileSystemView;
    }

    public void approveSelection() {
        this.returnValue = RETURN_TYPE.APPROVE;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed("ApproveSelection");
    }

    public void cancelSelection() {
        this.returnValue = RETURN_TYPE.CANCEL;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed("CancelSelection");
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        long mostRecentEventTime = EventQueue.getMostRecentEventTime();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, command, mostRecentEventTime, modifiers);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    public void updateUI() {
        if (this.isAcceptAllFileFilterUsed()) {
            this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        }
        if (this.defaultUI == null) {
            this.defaultUI = this.createDefaultUI();
            this.setUI(this.defaultUI);
        }
        if (this.fileSystemView == null) {
            this.setFileSystemView(AbstractVFSFileSystemView.getFileSystemView());
        }
        this.uiFileView = this.getUI().getFileView(this);
        if (this.isAcceptAllFileFilterUsed()) {
            this.addChoosableFileFilter(this.getAcceptAllFileFilter());
        }
    }

    @Override
    public String getUIClassID() {
        return "VFSFileChooserUI";
    }

    @Override
    public AbstractVFSFileChooserUI getUI() {
        return this.defaultUI;
    }

    protected MetalVFSFileChooserUI createDefaultUI() {
        return new MetalVFSFileChooserUI(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
    }

    @Override
    protected String paramString() {
        String fileSelectionModeString;
        String returnValueString;
        String dialogTypeString;
        String approveButtonTextString = this.approveButtonText != null ? this.approveButtonText : "";
        String dialogTitleString = this.dialogTitle != null ? this.dialogTitle : "";
        switch (this.dialogType) {
            case OPEN: {
                dialogTypeString = "OPEN_DIALOG";
                break;
            }
            case SAVE: {
                dialogTypeString = "SAVE_DIALOG";
                break;
            }
            case CUSTOM: {
                dialogTypeString = "CUSTOM_DIALOG";
                break;
            }
            default: {
                dialogTypeString = "";
            }
        }
        switch (this.returnValue) {
            case CANCEL: {
                returnValueString = "CANCEL_OPTION";
                break;
            }
            case APPROVE: {
                returnValueString = "APPROVE_OPTION";
                break;
            }
            case ERROR: {
                returnValueString = "ERROR_OPTION";
                break;
            }
            default: {
                returnValueString = "";
            }
        }
        String useFileHidingString = this.useFileHiding ? "true" : "false";
        switch (this.fileSelectionMode) {
            case FILES_ONLY: {
                fileSelectionModeString = "FILES_ONLY";
                break;
            }
            case DIRECTORIES_ONLY: {
                fileSelectionModeString = "DIRECTORIES_ONLY";
                break;
            }
            case FILES_AND_DIRECTORIES: {
                fileSelectionModeString = "FILES_AND_DIRECTORIES";
                break;
            }
            default: {
                fileSelectionModeString = "";
            }
        }
        String currentDirectoryString = this.currentDirectory != null ? this.currentDirectory.toString() : "";
        String selectedFileString = this.selectedFile != null ? this.selectedFile.toString() : "";
        return super.paramString() + ",approveButtonText=" + approveButtonTextString + ",currentDirectory=" + currentDirectoryString + ",dialogTitle=" + dialogTitleString + ",dialogType=" + dialogTypeString + ",fileSelectionMode=" + fileSelectionModeString + ",returnValue=" + returnValueString + ",selectedFile=" + selectedFileString + ",useFileHiding=" + useFileHidingString;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.m_accessibleContext == null) {
            this.m_accessibleContext = new AccessibleJFileChooser();
        }
        return this.m_accessibleContext;
    }

    public static enum SELECTION_MODE {
        FILES_ONLY,
        DIRECTORIES_ONLY,
        FILES_AND_DIRECTORIES;

    }

    public static enum RETURN_TYPE {
        CANCEL,
        APPROVE,
        ERROR,
        NO_SELECTION;

    }

    public static enum DIALOG_TYPE {
        OPEN,
        SAVE,
        CUSTOM;

    }

    protected class AccessibleJFileChooser
    extends JComponent.AccessibleJComponent {
        protected AccessibleJFileChooser() {
            super(VFSJFileChooser.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILE_CHOOSER;
        }
    }

    private static class WeakPCL
    implements PropertyChangeListener {
        WeakReference<VFSJFileChooser> jfcRef;

        public WeakPCL(VFSJFileChooser jfc) {
            this.jfcRef = new WeakReference<VFSJFileChooser>(jfc);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            assert (ev.getPropertyName().equals("awt.file.showHiddenFiles"));
            VFSJFileChooser jfc = (VFSJFileChooser)this.jfcRef.get();
            if (jfc == null) {
                Toolkit.getDefaultToolkit().removePropertyChangeListener("awt.file.showHiddenFiles", this);
            } else {
                boolean oldValue = jfc.useFileHiding;
                jfc.useFileHiding = (Boolean)ev.getNewValue() == false;
                jfc.firePropertyChange("FileHidingChanged", oldValue, jfc.useFileHiding);
            }
        }
    }
}

