/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.accessories;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.BookmarksDialog;
import com.googlecode.vfsjfilechooser2.accessories.connection.ConnectionDialog;
import com.googlecode.vfsjfilechooser2.utils.SwingCommonsUtilities;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.apache.commons.vfs2.FileObject;

public final class DefaultAccessoriesPanel
extends JComponent {
    private static final String RES_PATH = "/com/googlecode/vfsjfilechooser2/plaf/icons/";
    private JButton bookmarksButton;
    private JButton localFSButton;
    private JButton connectionsButton;
    private BookmarksDialog bookmarksDialog;
    private ConnectionDialog connectionDialog;
    private JComponent buttonsPanel;
    private VFSJFileChooser fileChooser;

    public DefaultAccessoriesPanel(VFSJFileChooser fileChooser) {
        this.setLayout(new BorderLayout());
        this.fileChooser = fileChooser;
        this.initBorder();
        this.initComponents();
    }

    private void initBorder() {
        EtchedBorder outsideBorder = new EtchedBorder();
        EmptyBorder insideBorder = new EmptyBorder(2, 4, 0, 2);
        CompoundBorder insideBorder1 = new CompoundBorder(outsideBorder, insideBorder);
        EmptyBorder outsideBorder1 = new EmptyBorder(0, 2, 0, 2);
        this.setBorder(new CompoundBorder(outsideBorder1, insideBorder1));
    }

    private Icon getIcon(String iconName) {
        URL iconURL = this.getClass().getResource(RES_PATH + iconName);
        return new ImageIcon(iconURL);
    }

    private void initComponents() {
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new GridLayout(0, 1, 3, 3));
        AbstractAction action = new ManageBookmarksAction(VFSResources.getMessage("VFSJFileChooser.bookmarksLabelText"), this.getIcon("book.png"));
        this.bookmarksButton = new JButton(action);
        this.bookmarksButton.setHorizontalAlignment(2);
        action = new ConnectionWizardAction(VFSResources.getMessage("VFSJFileChooser.connectionButtonText"), this.getIcon("connect.png"));
        this.connectionsButton = new JButton(action);
        this.connectionsButton.setHorizontalAlignment(2);
        action = new LocalFilesAction(VFSResources.getMessage("VFSJFileChooser.localFilesButtonText"), this.getIcon("drive.png"));
        this.localFSButton = new JButton(action);
        this.localFSButton.setHorizontalAlignment(2);
        this.buttonsPanel.add(this.bookmarksButton);
        this.buttonsPanel.add(Box.createVerticalStrut(20));
        this.buttonsPanel.add(this.connectionsButton);
        this.buttonsPanel.add(Box.createVerticalStrut(20));
        this.buttonsPanel.add(this.localFSButton);
        this.add((Component)this.buttonsPanel, "North");
        this.add((Component)new JPanel(), "Center");
        Frame c = (Frame)SwingUtilities.getWindowAncestor(this.fileChooser);
        this.bookmarksDialog = new BookmarksDialog(c, this.fileChooser);
        this.connectionDialog = new ConnectionDialog(c, this.bookmarksDialog, this.fileChooser);
    }

    private class ManageBookmarksAction
    extends AbstractAction {
        public ManageBookmarksAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultAccessoriesPanel.this.bookmarksDialog.setLocationRelativeTo(DefaultAccessoriesPanel.this.bookmarksDialog.getOwner());
            DefaultAccessoriesPanel.this.bookmarksDialog.setVisible(true);
        }
    }

    private class LocalFilesAction
    extends AbstractAction {
        public LocalFilesAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject fo = SwingCommonsUtilities.getVFSFileChooserDefaultDirectory();
            DefaultAccessoriesPanel.this.fileChooser.setCurrentDirectoryObject(fo);
        }
    }

    private class ConnectionWizardAction
    extends AbstractAction {
        public ConnectionWizardAction(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultAccessoriesPanel.this.connectionDialog.setLocationRelativeTo(DefaultAccessoriesPanel.this.connectionDialog.getOwner());
            DefaultAccessoriesPanel.this.connectionDialog.setVisible(true);
        }
    }
}

