/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.accessories.bookmarks;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.Bookmarks;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.BookmarksDialog;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.TitledURLEntry;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.vfs2.FileObject;

public class BookmarksManagerPanel
extends JPanel {
    public static final int NO_BOOKMARK_SELECTION_INDEX = -1;
    private JScrollPane scrollPane;
    private JTable table;
    private JButton bOpen;
    private JButton bCancel;
    private JButton bEdit;
    private JButton bAdd;
    private JButton bDelete;
    private JButton bMoveUp;
    private JButton bMoveDown;
    private Bookmarks model;
    private VFSJFileChooser chooser;
    private final Dimension tableSize = new Dimension(350, 200);
    private BookmarksDialog parentDialog;

    public BookmarksManagerPanel(BookmarksDialog parentDialog, VFSJFileChooser chooser) {
        this.parentDialog = parentDialog;
        this.chooser = chooser;
        this.model = new Bookmarks();
        this.table = new JTable(this.model);
        this.scrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(this.tableSize);
        this.table.setSelectionMode(2);
        this.bCancel = new JButton(VFSResources.getMessage("VFSJFileChooser.closeButtonText"));
        this.bOpen = new JButton(VFSResources.getMessage("VFSJFileChooser.openButtonText"));
        this.bOpen.setIcon(new ImageIcon(this.getClass().getResource("/com/googlecode/vfsjfilechooser2/plaf/icons/document-open.png")));
        this.bOpen.setHorizontalAlignment(2);
        this.bAdd = new JButton(VFSResources.getMessage("VFSJFileChooser.addButtonText"));
        this.bAdd.setIcon(new ImageIcon(this.getClass().getResource("/com/googlecode/vfsjfilechooser2/plaf/icons/list-add.png")));
        this.bAdd.setHorizontalAlignment(2);
        this.bEdit = new JButton(VFSResources.getMessage("VFSJFileChooser.editButtonText"));
        this.bEdit.setIcon(new ImageIcon(this.getClass().getResource("/com/googlecode/vfsjfilechooser2/plaf/icons/book_edit.png")));
        this.bEdit.setHorizontalAlignment(2);
        this.bDelete = new JButton(VFSResources.getMessage("VFSJFileChooser.deleteButtonText"));
        this.bDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/googlecode/vfsjfilechooser2/plaf/icons/list-remove.png")));
        this.bDelete.setHorizontalAlignment(2);
        this.bMoveUp = new JButton(VFSResources.getMessage("VFSJFileChooser.moveUpButtonText"));
        this.bMoveUp.setIcon(new ImageIcon(this.getClass().getResource("/com/googlecode/vfsjfilechooser2/plaf/icons/go-up.png")));
        this.bMoveUp.setHorizontalAlignment(2);
        this.bMoveDown = new JButton(VFSResources.getMessage("VFSJFileChooser.moveDownButtonText"));
        this.bMoveDown.setIcon(new ImageIcon(this.getClass().getResource("/com/googlecode/vfsjfilechooser2/plaf/icons/go-down.png")));
        this.bMoveDown.setHorizontalAlignment(2);
        ActionHandler ah = new ActionHandler();
        this.bOpen.addActionListener(ah);
        this.bCancel.addActionListener(ah);
        this.bEdit.addActionListener(ah);
        this.bAdd.addActionListener(ah);
        this.bDelete.addActionListener(ah);
        this.bMoveUp.addActionListener(ah);
        this.bMoveDown.addActionListener(ah);
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(this.bCancel);
        south.add(Box.createHorizontalGlue());
        JPanel buttons = new JPanel(new GridLayout(0, 1, 5, 5));
        buttons.add(this.bAdd);
        buttons.add(this.bEdit);
        buttons.add(this.bDelete);
        buttons.add(this.bOpen);
        buttons.add(Box.createVerticalStrut(10));
        buttons.add(this.bMoveUp);
        buttons.add(this.bMoveDown);
        JPanel east = new JPanel();
        east.add((Component)buttons, "North");
        east.add((Component)new JPanel(), "Center");
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)south, "South");
        this.add((Component)east, "East");
        this.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, UIManager.getColor("Panel.background")));
    }

    public Bookmarks getModel() {
        return this.model;
    }

    public void cancel() {
        this.parentDialog.setVisible(false);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JButton button = (JButton)actionEvent.getSource();
            final int row = BookmarksManagerPanel.this.table.getSelectedRow();
            if (button.equals(BookmarksManagerPanel.this.bAdd)) {
                BookmarksManagerPanel.this.parentDialog.showEditorView(-1);
            } else if (button.equals(BookmarksManagerPanel.this.bEdit)) {
                if (row != -1) {
                    BookmarksManagerPanel.this.parentDialog.showEditorView(row);
                } else {
                    JOptionPane.showMessageDialog(BookmarksManagerPanel.this.getParent(), VFSResources.getMessage("VFSJFileChooser.noselectionLabel"), VFSResources.getMessage("VFSJFileChooser.errorLabel"), 0);
                }
            } else if (button.equals(BookmarksManagerPanel.this.bOpen)) {
                if (row != -1) {
                    Thread worker = new Thread(){

                        @Override
                        public void run() {
                            BookmarksManagerPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                            TitledURLEntry aTitledURLEntry = BookmarksManagerPanel.this.model.getEntry(row);
                            FileObject fo = null;
                            try {
                                fo = VFSUtils.resolveFileObject(aTitledURLEntry.getURL());
                                if (fo != null && !fo.exists()) {
                                    fo = null;
                                }
                            }
                            catch (Exception exc) {
                                fo = null;
                            }
                            BookmarksManagerPanel.this.setCursor(Cursor.getDefaultCursor());
                            if (fo == null) {
                                StringBuilder msg = new StringBuilder();
                                msg.append("Failed to connect to ");
                                msg.append(aTitledURLEntry.getURL());
                                msg.append("\n");
                                msg.append("Please check URL entry and try again.");
                                JOptionPane.showMessageDialog(null, msg, "Error", 0);
                            } else {
                                BookmarksManagerPanel.this.chooser.setCurrentDirectoryObject(fo);
                                BookmarksManagerPanel.this.parentDialog.setVisible(false);
                            }
                        }
                    };
                    worker.setPriority(1);
                    SwingUtilities.invokeLater(worker);
                } else {
                    JOptionPane.showMessageDialog(BookmarksManagerPanel.this.getParent(), VFSResources.getMessage("VFSJFileChooser.noselectionLabel"), VFSResources.getMessage("VFSJFileChooser.errorLabel"), 0);
                }
            } else if (button.equals(BookmarksManagerPanel.this.bDelete)) {
                int[] rows = BookmarksManagerPanel.this.table.getSelectedRows();
                if (rows.length == 0) {
                    JOptionPane.showMessageDialog(BookmarksManagerPanel.this.getParent(), VFSResources.getMessage("VFSJFileChooser.noselectionLabel"), VFSResources.getMessage("VFSJFileChooser.errorLabel"), 0);
                    return;
                }
                for (int i = rows.length - 1; i >= 0; --i) {
                    BookmarksManagerPanel.this.model.delete(rows[i]);
                }
            } else if (button.equals(BookmarksManagerPanel.this.bMoveUp)) {
                int[] rows = BookmarksManagerPanel.this.table.getSelectedRows();
                if (rows.length == 0) {
                    JOptionPane.showMessageDialog(BookmarksManagerPanel.this.getParent(), VFSResources.getMessage("VFSJFileChooser.noselectionLabel"), VFSResources.getMessage("VFSJFileChooser.errorLabel"), 0);
                    return;
                }
                if (rows.length > 1) {
                    return;
                }
                if (rows[0] > 0) {
                    BookmarksManagerPanel.this.model.moveup(rows[0]);
                    BookmarksManagerPanel.this.table.setRowSelectionInterval(rows[0] - 1, rows[0] - 1);
                }
            } else if (button.equals(BookmarksManagerPanel.this.bMoveDown)) {
                int[] rows = BookmarksManagerPanel.this.table.getSelectedRows();
                if (rows.length == 0) {
                    JOptionPane.showMessageDialog(BookmarksManagerPanel.this.getParent(), VFSResources.getMessage("VFSJFileChooser.noselectionLabel"), VFSResources.getMessage("VFSJFileChooser.errorLabel"), 0);
                    return;
                }
                if (rows.length > 1) {
                    return;
                }
                if (rows[0] < BookmarksManagerPanel.this.model.getRowCount() - 1) {
                    BookmarksManagerPanel.this.model.movedown(rows[0]);
                    BookmarksManagerPanel.this.table.setRowSelectionInterval(rows[0] + 1, rows[0] + 1);
                }
            } else if (button.equals(BookmarksManagerPanel.this.bCancel)) {
                BookmarksManagerPanel.this.cancel();
            }
        }
    }
}

