/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.plaf.basic;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileFilter;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileSystemView;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileView;
import com.googlecode.vfsjfilechooser2.plaf.AbstractVFSFileChooserUI;
import com.googlecode.vfsjfilechooser2.plaf.basic.AbstractVFSUIAction;
import com.googlecode.vfsjfilechooser2.plaf.basic.BasicVFSDirectoryModel;
import com.googlecode.vfsjfilechooser2.utils.SwingCommonsUtilities;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.local.LocalFile;

public class BasicVFSFileChooserUI
extends AbstractVFSFileChooserUI {
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected Icon viewMenuIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected int directoryOpenButtonMnemonic = 0;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String updateButtonText = null;
    protected String helpButtonText = null;
    protected String directoryOpenButtonText = null;
    private String openDialogTitleText = null;
    private String saveDialogTitleText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String updateButtonToolTipText = null;
    protected String helpButtonToolTipText = null;
    protected String directoryOpenButtonToolTipText = null;
    private Action approveSelectionAction = new ApproveSelectionAction();
    private Action cancelSelectionAction = new CancelSelectionAction();
    private Action updateAction = new UpdateAction();
    private Action newFolderAction;
    private Action goHomeAction = new GoHomeAction();
    private Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String newFolderParentDoesntExistTitleText = null;
    private String newFolderParentDoesntExistText = null;
    private String fileDescriptionText = null;
    private String directoryDescriptionText = null;
    private VFSJFileChooser filechooser = null;
    private boolean directorySelected = false;
    private FileObject directory = null;
    private PropertyChangeListener propertyChangeListener = null;
    private AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    private AbstractVFSFileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private BasicVFSDirectoryModel model = null;
    private BasicVFSFileView fileView = new BasicVFSFileView();
    private boolean usesSingleFilePane;
    private boolean readOnly;
    private JPanel accessoryPanel = null;
    private Handler handler;

    public BasicVFSFileChooserUI(VFSJFileChooser b) {
        this.filechooser = b;
    }

    @Override
    public void installUI(JComponent c) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (VFSJFileChooser)c;
        this.createModel();
        this.clearIconCache();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        this.filechooser.applyComponentOrientation(this.filechooser.getComponentOrientation());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
        this.handler = null;
    }

    public void installComponents(VFSJFileChooser fc) {
    }

    public void uninstallComponents(VFSJFileChooser fc) {
    }

    protected void installListeners(VFSJFileChooser fc) {
        this.propertyChangeListener = this.createPropertyChangeListener(fc);
        if (this.propertyChangeListener != null) {
            fc.addPropertyChangeListener(this.propertyChangeListener);
        }
        fc.addPropertyChangeListener(this.getModel());
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        AbstractVFSUIAction refreshAction = new AbstractVFSUIAction("refresh"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicVFSFileChooserUI.this.getFileChooser().rescanCurrentDirectory();
            }
        };
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", this.getCancelSelectionAction());
        map.put("refresh", refreshAction);
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        return map;
    }

    protected void uninstallListeners(VFSJFileChooser fc) {
        if (this.propertyChangeListener != null) {
            fc.removePropertyChangeListener(this.propertyChangeListener);
        }
        fc.removePropertyChangeListener(this.getModel());
        SwingUtilities.replaceUIInputMap(fc, 1, null);
        SwingUtilities.replaceUIActionMap(fc, null);
    }

    protected void installDefaults(VFSJFileChooser fc) {
        this.installIcons(fc);
        this.installStrings(fc);
        this.usesSingleFilePane = UIManager.getBoolean("FileChooser.usesSingleFilePane");
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        LookAndFeel.installProperty(fc, "opaque", Boolean.FALSE);
    }

    protected void installIcons(VFSJFileChooser fc) {
        UIDefaults defaults = UIManager.getLookAndFeel().getDefaults();
        this.directoryIcon = this.lookupIcon("folder.png");
        this.fileIcon = this.lookupIcon("file.png");
        this.computerIcon = defaults.getIcon("FileView.computerIcon");
        this.hardDriveIcon = defaults.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = defaults.getIcon("FileView.floppyDriveIcon");
        this.newFolderIcon = this.lookupIcon("folder_add.png");
        this.upFolderIcon = this.lookupIcon("go-up.png");
        this.homeFolderIcon = this.lookupIcon("folder_user.png");
        this.detailsViewIcon = this.lookupIcon("application_view_detail.png");
        this.listViewIcon = this.lookupIcon("application_view_list.png");
        this.viewMenuIcon = defaults.getIcon("FileChooser.viewMenuIcon");
    }

    private Icon lookupIcon(String path) {
        return new ImageIcon(this.getClass().getResource("/com/googlecode/vfsjfilechooser2/plaf/icons/" + path));
    }

    protected void installStrings(VFSJFileChooser fc) {
        Locale l = fc.getLocale();
        this.newFolderErrorText = VFSResources.getMessage("VFSJFileChooser.newFolderErrorText");
        this.newFolderErrorSeparator = VFSResources.getMessage("VFSJFileChooser.newFolderErrorSeparator");
        this.newFolderParentDoesntExistTitleText = VFSResources.getMessage("VFSJFileChooser.newFolderParentDoesntExistTitleText");
        this.newFolderParentDoesntExistText = VFSResources.getMessage("VFSJFileChooser.newFolderParentDoesntExistText");
        this.fileDescriptionText = VFSResources.getMessage("VFSJFileChooser.fileDescriptionText");
        this.directoryDescriptionText = VFSResources.getMessage("VFSJFileChooser.directoryDescriptionText");
        this.saveButtonText = VFSResources.getMessage("VFSJFileChooser.saveButtonText");
        this.openButtonText = VFSResources.getMessage("VFSJFileChooser.openButtonText");
        this.saveDialogTitleText = VFSResources.getMessage("VFSJFileChooser.saveDialogTitleText");
        this.openDialogTitleText = VFSResources.getMessage("VFSJFileChooser.openDialogTitleText");
        this.cancelButtonText = VFSResources.getMessage("VFSJFileChooser.cancelButtonText");
        this.updateButtonText = VFSResources.getMessage("VFSJFileChooser.updateButtonText");
        this.helpButtonText = VFSResources.getMessage("VFSJFileChooser.helpButtonText");
        this.directoryOpenButtonText = VFSResources.getMessage("VFSJFileChooser.directoryOpenButtonText");
        this.saveButtonMnemonic = this.getMnemonic("VFSJFileChooser.saveButtonMnemonic", l);
        this.openButtonMnemonic = this.getMnemonic("VFSJFileChooser.openButtonMnemonic", l);
        this.cancelButtonMnemonic = this.getMnemonic("VFSJFileChooser.cancelButtonMnemonic", l);
        this.updateButtonMnemonic = this.getMnemonic("VFSJFileChooser.updateButtonMnemonic", l);
        this.helpButtonMnemonic = this.getMnemonic("VFSJFileChooser.helpButtonMnemonic", l);
        this.directoryOpenButtonMnemonic = this.getMnemonic("VFSJFileChooser.directoryOpenButtonMnemonic", l);
        this.saveButtonToolTipText = VFSResources.getMessage("VFSJFileChooser.saveButtonToolTipText");
        this.openButtonToolTipText = VFSResources.getMessage("VFSJFileChooser.openButtonToolTipText");
        this.cancelButtonToolTipText = VFSResources.getMessage("VFSJFileChooser.cancelButtonToolTipText");
        this.updateButtonToolTipText = VFSResources.getMessage("VFSJFileChooser.updateButtonToolTipText");
        this.helpButtonToolTipText = VFSResources.getMessage("VFSJFileChooser.helpButtonToolTipText");
        this.directoryOpenButtonToolTipText = VFSResources.getMessage("VFSJFileChooser.directoryOpenButtonToolTipText");
    }

    protected void uninstallDefaults(VFSJFileChooser fc) {
        this.uninstallIcons(fc);
        this.uninstallStrings(fc);
    }

    protected void uninstallIcons(VFSJFileChooser fc) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
        this.viewMenuIcon = null;
    }

    protected void uninstallStrings(VFSJFileChooser fc) {
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.updateButtonText = null;
        this.helpButtonText = null;
        this.directoryOpenButtonText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.updateButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.directoryOpenButtonToolTipText = null;
    }

    protected void createModel() {
        if (this.model != null) {
            this.model.invalidateFileCache();
        }
        this.model = new BasicVFSDirectoryModel(this.getFileChooser());
    }

    public BasicVFSDirectoryModel getModel() {
        return this.model;
    }

    public PropertyChangeListener createPropertyChangeListener(VFSJFileChooser fc) {
        return null;
    }

    public String getFileName() {
        return null;
    }

    public String getDirectoryName() {
        return null;
    }

    public void setFileName(String filename) {
    }

    public void setDirectoryName(String dirname) {
    }

    @Override
    public void rescanCurrentDirectory(VFSJFileChooser fc) {
    }

    @Override
    public void ensureFileIsVisible(VFSJFileChooser fc, FileObject f) {
    }

    public VFSJFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    protected JButton getApproveButton(VFSJFileChooser fc) {
        return null;
    }

    public String getApproveButtonToolTipText(VFSJFileChooser fc) {
        String tooltipText = fc.getApproveButtonToolTipText();
        if (tooltipText != null) {
            return tooltipText;
        }
        if (fc.getDialogType() == VFSJFileChooser.DIALOG_TYPE.OPEN) {
            return this.openButtonToolTipText;
        }
        if (fc.getDialogType() == VFSJFileChooser.DIALOG_TYPE.SAVE) {
            return this.saveButtonToolTipText;
        }
        return null;
    }

    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseListener createDoubleClickListener(VFSJFileChooser fc, JList list) {
        return new Handler(list);
    }

    public ListSelectionListener createListSelectionListener(VFSJFileChooser fc) {
        return this.getHandler();
    }

    protected boolean isDirectorySelected() {
        return this.directorySelected;
    }

    protected void setDirectorySelected(boolean b) {
        this.directorySelected = b;
    }

    protected FileObject getDirectory() {
        return this.directory;
    }

    protected void setDirectory(FileObject f) {
        this.directory = f;
    }

    public static int getUIDefaultsInt(Object key, Locale l, int defaultValue) {
        Object value = UIManager.get(key, l);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private int getMnemonic(String key, Locale l) {
        return BasicVFSFileChooserUI.getUIDefaultsInt(key, l, 0);
    }

    @Override
    public AbstractVFSFileFilter getAcceptAllFileFilter(VFSJFileChooser fc) {
        return this.acceptAllFileFilter;
    }

    @Override
    public AbstractVFSFileView getFileView(VFSJFileChooser fc) {
        return this.fileView;
    }

    @Override
    public String getDialogTitle(VFSJFileChooser fc) {
        String dialogTitle = fc.getDialogTitle();
        if (dialogTitle != null) {
            return dialogTitle;
        }
        if (fc.getDialogType() == VFSJFileChooser.DIALOG_TYPE.OPEN) {
            return this.openDialogTitleText;
        }
        if (fc.getDialogType() == VFSJFileChooser.DIALOG_TYPE.SAVE) {
            return this.saveDialogTitleText;
        }
        return this.getApproveButtonText(fc);
    }

    public int getApproveButtonMnemonic(VFSJFileChooser fc) {
        int mnemonic = fc.getApproveButtonMnemonic();
        if (mnemonic > 0) {
            return mnemonic;
        }
        if (fc.getDialogType() == VFSJFileChooser.DIALOG_TYPE.OPEN) {
            return this.openButtonMnemonic;
        }
        if (fc.getDialogType() == VFSJFileChooser.DIALOG_TYPE.SAVE) {
            return this.saveButtonMnemonic;
        }
        return mnemonic;
    }

    @Override
    public String getApproveButtonText(VFSJFileChooser fc) {
        String buttonText = fc.getApproveButtonText();
        if (buttonText != null) {
            return buttonText;
        }
        if (fc.getDialogType() == VFSJFileChooser.DIALOG_TYPE.OPEN) {
            return this.openButtonText;
        }
        if (fc.getDialogType() == VFSJFileChooser.DIALOG_TYPE.SAVE) {
            return this.saveButtonText;
        }
        return null;
    }

    public Action getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new NewFolderAction();
            if (this.readOnly) {
                this.newFolderAction.setEnabled(false);
            }
        }
        return this.newFolderAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getUpdateAction() {
        return this.updateAction;
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            VFSJFileChooser chooser = this.getFileChooser();
            AbstractVFSFileFilter currentFilter = chooser.getFileFilter();
            if (currentFilter != null && currentFilter.equals(this.globFilter)) {
                chooser.setFileFilter(this.actualFileFilter);
                chooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private static boolean isGlobPattern(String filename) {
        return File.separatorChar == '\\' && (filename.indexOf(42) >= 0 || filename.indexOf(63) >= 0) || File.separatorChar == '/' && (filename.indexOf(42) >= 0 || filename.indexOf(63) >= 0 || filename.indexOf(91) >= 0);
    }

    public void changeDirectory(FileObject dir) {
        VFSJFileChooser fc = this.getFileChooser();
        fc.setCurrentDirectoryObject(dir);
        if (fc.getFileSelectionMode() == VFSJFileChooser.SELECTION_MODE.FILES_AND_DIRECTORIES && fc.getFileSystemView().isFileSystem(dir)) {
            this.setFileName(dir.getName().getBaseName());
        }
    }

    public class BasicVFSFileView
    extends AbstractVFSFileView {
        protected Map<FileObject, Icon> iconCache = new ConcurrentHashMap<FileObject, Icon>();

        public void clearIconCache() {
            this.iconCache = null;
            this.iconCache = new ConcurrentHashMap<FileObject, Icon>();
        }

        @Override
        public String getName(FileObject f) {
            String fileName = null;
            if (f != null) {
                fileName = f.getName().getBaseName();
            }
            if (fileName != null && fileName.trim().equals("")) {
                fileName = f.getName().toString();
            }
            return fileName;
        }

        @Override
        public String getDescription(FileObject f) {
            return f.getName().getBaseName();
        }

        @Override
        public String getTypeDescription(FileObject f) {
            String type = BasicVFSFileChooserUI.this.getFileChooser().getFileSystemView().getSystemTypeDescription(f);
            if (type == null) {
                type = VFSUtils.isDirectory(f) ? BasicVFSFileChooserUI.this.directoryDescriptionText : BasicVFSFileChooserUI.this.fileDescriptionText;
            }
            return type;
        }

        public Icon getCachedIcon(FileObject f) {
            return this.iconCache.get(f);
        }

        public void cacheIcon(FileObject f, Icon i) {
            if (f == null || i == null) {
                return;
            }
            this.iconCache.put(f, i);
        }

        @Override
        public Icon getIcon(FileObject f) {
            Icon icon = this.getCachedIcon(f);
            if (icon != null) {
                return icon;
            }
            icon = BasicVFSFileChooserUI.this.fileIcon;
            if (f != null) {
                AbstractVFSFileSystemView fsv = BasicVFSFileChooserUI.this.getFileChooser().getFileSystemView();
                if (fsv.isFloppyDrive(f)) {
                    icon = BasicVFSFileChooserUI.this.floppyDriveIcon;
                } else if (fsv.isDrive(f)) {
                    icon = BasicVFSFileChooserUI.this.hardDriveIcon;
                } else if (fsv.isComputerNode(f)) {
                    icon = BasicVFSFileChooserUI.this.computerIcon;
                } else if (VFSUtils.isDirectory(f)) {
                    icon = BasicVFSFileChooserUI.this.directoryIcon;
                }
            }
            this.cacheIcon(f, icon);
            return icon;
        }

        public Boolean isHidden(FileObject f) {
            return VFSUtils.isHiddenFile(f);
        }
    }

    protected static class AcceptAllFileFilter
    extends AbstractVFSFileFilter {
        @Override
        public boolean accept(FileObject f) {
            return true;
        }

        @Override
        public String getDescription() {
            return VFSResources.getMessage("VFSJFileChooser.acceptAllFileFilterText");
        }

        public String toString() {
            return this.getDescription();
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        protected UpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VFSJFileChooser fc = BasicVFSFileChooserUI.this.getFileChooser();
            fc.setCurrentDirectoryObject(fc.getFileSystemView().createFileObject(BasicVFSFileChooserUI.this.getDirectoryName()));
            fc.rescanCurrentDirectory();
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        protected CancelSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicVFSFileChooserUI.this.getFileChooser().cancelSelection();
        }
    }

    static class GlobFilter
    extends AbstractVFSFileFilter {
        String globPattern;

        GlobFilter() {
        }

        public void setPattern(String globPattern) {
            this.globPattern = globPattern;
        }

        @Override
        public boolean accept(FileObject f) {
            if (f == null) {
                return false;
            }
            if (VFSUtils.isDirectory(f)) {
                return true;
            }
            return FilenameUtils.wildcardMatch((String)f.getName().getBaseName(), (String)this.globPattern);
        }

        @Override
        public String getDescription() {
            return this.globPattern;
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        protected ApproveSelectionAction() {
            super("approveSelection");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject dir;
            if (BasicVFSFileChooserUI.this.isDirectorySelected() && (dir = BasicVFSFileChooserUI.this.getDirectory()) != null) {
                BasicVFSFileChooserUI.this.changeDirectory(dir);
                return;
            }
            VFSJFileChooser chooser = BasicVFSFileChooserUI.this.getFileChooser();
            String filename = BasicVFSFileChooserUI.this.getFileName();
            AbstractVFSFileSystemView fs = chooser.getFileSystemView();
            FileObject dir2 = chooser.getCurrentDirectoryObject();
            if (filename != null) {
                filename = filename.trim();
            }
            if (filename == null || filename.equals("")) {
                BasicVFSFileChooserUI.this.resetGlobFilter();
                return;
            }
            FileObject selectedFile = null;
            FileObject[] selectedFiles = null;
            if (filename != null && !filename.equals("")) {
                if (File.separatorChar == '/') {
                    if (filename.startsWith("~/")) {
                        filename = System.getProperty("user.home") + filename.substring(1);
                    } else if (filename.equals("~")) {
                        filename = System.getProperty("user.home");
                    }
                }
                if (chooser.isMultiSelectionEnabled() && filename.charAt(0) == '\"') {
                    ArrayList<FileObject> fList = new ArrayList<FileObject>();
                    if ((filename = filename.substring(1)).endsWith("\"")) {
                        filename = filename.substring(0, filename.length() - 1);
                    }
                    do {
                        String str;
                        int i;
                        if ((i = filename.indexOf("\" \"")) > 0) {
                            str = filename.substring(0, i);
                            filename = filename.substring(i + 3);
                        } else {
                            str = filename;
                            filename = "";
                        }
                        FileObject file = fs.createFileObject(str);
                        if (file == null) {
                            file = fs.createFileObject(dir2, str);
                        }
                        fList.add(file);
                    } while (filename.length() > 0);
                    if (!fList.isEmpty()) {
                        selectedFiles = fList.toArray(new FileObject[fList.size()]);
                    }
                    BasicVFSFileChooserUI.this.resetGlobFilter();
                } else {
                    boolean isCtrl;
                    selectedFile = fs.createFileObject(filename);
                    if (!(VFSUtils.exists(selectedFile) || (selectedFile = VFSUtils.resolveFileObject(BasicVFSFileChooserUI.this.getFileName())) != null && VFSUtils.exists(selectedFile))) {
                        selectedFile = fs.getChild(dir2, filename);
                    }
                    AbstractVFSFileFilter currentFilter = chooser.getFileFilter();
                    if (!VFSUtils.exists(selectedFile) && BasicVFSFileChooserUI.isGlobPattern(filename)) {
                        BasicVFSFileChooserUI.this.changeDirectory(VFSUtils.getParentDirectory(selectedFile));
                        if (BasicVFSFileChooserUI.this.globFilter == null) {
                            BasicVFSFileChooserUI.this.globFilter = new GlobFilter();
                        }
                        try {
                            BasicVFSFileChooserUI.this.globFilter.setPattern(selectedFile.getName().getBaseName());
                            if (!(currentFilter instanceof GlobFilter)) {
                                BasicVFSFileChooserUI.this.actualFileFilter = currentFilter;
                            }
                            chooser.setFileFilter(null);
                            chooser.setFileFilter(BasicVFSFileChooserUI.this.globFilter);
                            return;
                        }
                        catch (PatternSyntaxException pse) {
                            // empty catch block
                        }
                    }
                    BasicVFSFileChooserUI.this.resetGlobFilter();
                    boolean isDir = selectedFile != null && VFSUtils.isDirectory(selectedFile);
                    boolean isTrav = selectedFile != null && chooser.isTraversable(selectedFile);
                    boolean isDirSelEnabled = chooser.isDirectorySelectionEnabled();
                    boolean isFileSelEnabled = chooser.isFileSelectionEnabled();
                    boolean bl = isCtrl = e != null && (e.getModifiers() & 2) != 0;
                    if (isDir && isTrav && (isCtrl || !isDirSelEnabled)) {
                        BasicVFSFileChooserUI.this.changeDirectory(selectedFile);
                        return;
                    }
                    if (!(!isDir && isFileSelEnabled || isDir && isDirSelEnabled || isDirSelEnabled && !VFSUtils.exists(selectedFile))) {
                        selectedFile = null;
                    }
                }
            }
            if (selectedFiles != null || selectedFile != null) {
                if (selectedFiles != null || chooser.isMultiSelectionEnabled()) {
                    if (selectedFiles == null) {
                        selectedFiles = new FileObject[]{selectedFile};
                    }
                    chooser.setSelectedFileObjects(selectedFiles);
                    chooser.setSelectedFileObjects(selectedFiles);
                } else {
                    chooser.setSelectedFileObject(selectedFile);
                }
                chooser.approveSelection();
            } else {
                if (chooser.isMultiSelectionEnabled()) {
                    chooser.setSelectedFileObjects(null);
                } else {
                    chooser.setSelectedFile(null);
                }
                chooser.cancelSelection();
            }
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
            this.putValue("ActionCommandKey", "Go Up");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (focusOwner == null || !(focusOwner instanceof JTextComponent)) {
                BasicVFSFileChooserUI.this.getFileChooser().changeToParentDirectory();
            }
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VFSJFileChooser fc = BasicVFSFileChooserUI.this.getFileChooser();
            FileObject currentDir = fc.getCurrentDirectoryObject();
            if (currentDir instanceof LocalFile) {
                BasicVFSFileChooserUI.this.changeDirectory(fc.getFileSystemView().getHomeDirectory());
            } else {
                try {
                    BasicVFSFileChooserUI.this.changeDirectory(fc.getCurrentDirectoryObject().getFileSystem().getRoot());
                }
                catch (FileSystemException ex) {
                    Logger.getLogger(BasicVFSFileChooserUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicVFSFileChooserUI.this.readOnly) {
                return;
            }
            VFSJFileChooser fc = BasicVFSFileChooserUI.this.getFileChooser();
            FileObject currentDirectory = fc.getCurrentDirectoryObject();
            if (!VFSUtils.exists(currentDirectory)) {
                JOptionPane.showMessageDialog(fc, BasicVFSFileChooserUI.this.newFolderParentDoesntExistText, BasicVFSFileChooserUI.this.newFolderParentDoesntExistTitleText, 2);
                return;
            }
            try {
                FileObject newFolder = fc.getFileSystemView().createNewFolder(currentDirectory);
                if (fc.isMultiSelectionEnabled()) {
                    fc.setSelectedFileObjects(new FileObject[]{newFolder});
                } else {
                    fc.setSelectedFileObject(newFolder);
                }
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(fc, BasicVFSFileChooserUI.this.newFolderErrorText + BasicVFSFileChooserUI.this.newFolderErrorSeparator + exc, BasicVFSFileChooserUI.this.newFolderErrorText, 0);
                return;
            }
            fc.rescanCurrentDirectory();
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        protected SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            BasicVFSFileChooserUI.this.getHandler().valueChanged(e);
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        Handler handler;

        public DoubleClickListener(JList list) {
            this.handler = new Handler(list);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.handler.mouseEntered(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handler.mouseClicked(e);
        }
    }

    private class Handler
    implements MouseListener,
    ListSelectionListener {
        JList list;

        Handler() {
        }

        Handler(JList list) {
            this.list = list;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int index;
            if (this.list != null && SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2 && (index = SwingCommonsUtilities.loc2IndexFileList(this.list, evt.getPoint())) >= 0) {
                FileObject f = (FileObject)this.list.getModel().getElementAt(index);
                if (BasicVFSFileChooserUI.this.getFileChooser().isTraversable(f)) {
                    this.list.clearSelection();
                    BasicVFSFileChooserUI.this.changeDirectory(f);
                } else {
                    BasicVFSFileChooserUI.this.getFileChooser().approveSelection();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            if (this.list != null) {
                TransferHandler th2;
                TransferHandler th1 = BasicVFSFileChooserUI.this.getFileChooser().getTransferHandler();
                if (th1 != (th2 = this.list.getTransferHandler())) {
                    this.list.setTransferHandler(th1);
                }
                if (BasicVFSFileChooserUI.this.getFileChooser().getDragEnabled() != this.list.getDragEnabled()) {
                    this.list.setDragEnabled(BasicVFSFileChooserUI.this.getFileChooser().getDragEnabled());
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (!evt.getValueIsAdjusting()) {
                boolean useSetDirectory;
                VFSJFileChooser chooser = BasicVFSFileChooserUI.this.getFileChooser();
                AbstractVFSFileSystemView fsv = chooser.getFileSystemView();
                JList list = (JList)evt.getSource();
                VFSJFileChooser.SELECTION_MODE fsm = chooser.getFileSelectionMode();
                boolean bl = useSetDirectory = BasicVFSFileChooserUI.this.usesSingleFilePane && fsm == VFSJFileChooser.SELECTION_MODE.FILES_ONLY;
                if (chooser.isMultiSelectionEnabled()) {
                    FileObject[] files = new FileObject[]{};
                    Object[] objects = list.getSelectedValues();
                    if (objects != null) {
                        int count = objects.length;
                        if (count == 1 && VFSUtils.isDirectory((FileObject)objects[0]) && chooser.isTraversable((FileObject)objects[0]) && (useSetDirectory || !fsv.isFileSystem((FileObject)objects[0]))) {
                            BasicVFSFileChooserUI.this.setDirectorySelected(true);
                            BasicVFSFileChooserUI.this.setDirectory((FileObject)objects[0]);
                        } else {
                            ArrayList<FileObject> fList = new ArrayList<FileObject>(count);
                            for (int i = 0; i < count; ++i) {
                                FileObject f = (FileObject)objects[i];
                                boolean isDir = VFSUtils.isDirectory(f);
                                if ((!chooser.isFileSelectionEnabled() || isDir) && (!chooser.isDirectorySelectionEnabled() || !fsv.isFileSystem(f) || !isDir)) continue;
                                fList.add(f);
                            }
                            if (!fList.isEmpty()) {
                                files = fList.toArray(new FileObject[fList.size()]);
                            }
                            BasicVFSFileChooserUI.this.setDirectorySelected(false);
                        }
                    }
                    chooser.setSelectedFileObjects(files);
                } else {
                    FileObject file = (FileObject)list.getSelectedValue();
                    if (file != null && chooser.isTraversable(file) && (useSetDirectory || !fsv.isFileSystem(file))) {
                        BasicVFSFileChooserUI.this.setDirectorySelected(true);
                        BasicVFSFileChooserUI.this.setDirectory(file);
                        if (BasicVFSFileChooserUI.this.usesSingleFilePane) {
                            chooser.setSelectedFileObject(null);
                        }
                    } else {
                        BasicVFSFileChooserUI.this.setDirectorySelected(false);
                        if (file != null) {
                            chooser.setSelectedFileObject(file);
                        }
                    }
                }
            }
        }
    }
}

