/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.core.attributeclassobservers;

import moa.classifiers.core.AttributeSplitSuggestion;
import moa.classifiers.core.attributeclassobservers.DiscreteAttributeClassObserver;
import moa.classifiers.core.conditionaltests.NominalAttributeBinaryTest;
import moa.classifiers.core.conditionaltests.NominalAttributeMultiwayTest;
import moa.classifiers.core.splitcriteria.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.tasks.TaskMonitor;
import weka.core.Utils;

public class NominalAttributeClassObserver
extends AbstractOptionHandler
implements DiscreteAttributeClassObserver {
    private static final long serialVersionUID = 1L;
    protected double totalWeightObserved = 0.0;
    protected double missingWeightObserved = 0.0;
    public AutoExpandVector<DoubleVector> attValDistPerClass = new AutoExpandVector();

    @Override
    public void observeAttributeClass(double attVal, int classVal, double weight) {
        if (Utils.isMissingValue((double)attVal)) {
            this.missingWeightObserved += weight;
        } else {
            int attValInt = (int)attVal;
            DoubleVector valDist = this.attValDistPerClass.get(classVal);
            if (valDist == null) {
                valDist = new DoubleVector();
                this.attValDistPerClass.set(classVal, valDist);
            }
            valDist.addToValue(attValInt, weight);
        }
        this.totalWeightObserved += weight;
    }

    @Override
    public double probabilityOfAttributeValueGivenClass(double attVal, int classVal) {
        DoubleVector obs = this.attValDistPerClass.get(classVal);
        return obs != null ? (obs.getValue((int)attVal) + 1.0) / (obs.sumOfValues() + (double)obs.numValues()) : 0.0;
    }

    public double totalWeightOfClassObservations() {
        return this.totalWeightObserved;
    }

    public double weightOfObservedMissingValues() {
        return this.missingWeightObserved;
    }

    @Override
    public AttributeSplitSuggestion getBestEvaluatedSplitSuggestion(SplitCriterion criterion, double[] preSplitDist, int attIndex, boolean binaryOnly) {
        AttributeSplitSuggestion bestSuggestion = null;
        int maxAttValsObserved = this.getMaxAttValsObserved();
        if (!binaryOnly) {
            double[][] postSplitDists = this.getClassDistsResultingFromMultiwaySplit(maxAttValsObserved);
            double merit = criterion.getMeritOfSplit(preSplitDist, postSplitDists);
            bestSuggestion = new AttributeSplitSuggestion(new NominalAttributeMultiwayTest(attIndex), postSplitDists, merit);
        }
        for (int valIndex = 0; valIndex < maxAttValsObserved; ++valIndex) {
            double[][] postSplitDists = this.getClassDistsResultingFromBinarySplit(valIndex);
            double merit = criterion.getMeritOfSplit(preSplitDist, postSplitDists);
            if (bestSuggestion != null && !(merit > bestSuggestion.merit)) continue;
            bestSuggestion = new AttributeSplitSuggestion(new NominalAttributeBinaryTest(attIndex, valIndex), postSplitDists, merit);
        }
        return bestSuggestion;
    }

    public int getMaxAttValsObserved() {
        int maxAttValsObserved = 0;
        for (DoubleVector attValDist : this.attValDistPerClass) {
            if (attValDist == null || attValDist.numValues() <= maxAttValsObserved) continue;
            maxAttValsObserved = attValDist.numValues();
        }
        return maxAttValsObserved;
    }

    public double[][] getClassDistsResultingFromMultiwaySplit(int maxAttValsObserved) {
        int i;
        DoubleVector[] resultingDists = new DoubleVector[maxAttValsObserved];
        for (i = 0; i < resultingDists.length; ++i) {
            resultingDists[i] = new DoubleVector();
        }
        for (i = 0; i < this.attValDistPerClass.size(); ++i) {
            DoubleVector attValDist = this.attValDistPerClass.get(i);
            if (attValDist == null) continue;
            for (int j = 0; j < attValDist.numValues(); ++j) {
                resultingDists[j].addToValue(i, attValDist.getValue(j));
            }
        }
        double[][] distributions = new double[maxAttValsObserved][];
        for (int i2 = 0; i2 < distributions.length; ++i2) {
            distributions[i2] = resultingDists[i2].getArrayRef();
        }
        return distributions;
    }

    public double[][] getClassDistsResultingFromBinarySplit(int valIndex) {
        DoubleVector equalsDist = new DoubleVector();
        DoubleVector notEqualDist = new DoubleVector();
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            DoubleVector attValDist = this.attValDistPerClass.get(i);
            if (attValDist == null) continue;
            for (int j = 0; j < attValDist.numValues(); ++j) {
                if (j == valIndex) {
                    equalsDist.addToValue(i, attValDist.getValue(j));
                    continue;
                }
                notEqualDist.addToValue(i, attValDist.getValue(j));
            }
        }
        return new double[][]{equalsDist.getArrayRef(), notEqualDist.getArrayRef()};
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }
}

