/*
 * Decompiled with CFR 0.152.
 */
package moa.core;

import java.util.ArrayList;
import moa.AbstractMOAObject;
import moa.core.GaussianEstimator;
import moa.core.StringUtils;

public class Measurement
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected double value;

    public Measurement(String name, double value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public static Measurement getMeasurementNamed(String name, Measurement[] measurements) {
        for (Measurement measurement : measurements) {
            if (!name.equals(measurement.getName())) continue;
            return measurement;
        }
        return null;
    }

    public static void getMeasurementsDescription(Measurement[] measurements, StringBuilder out, int indent) {
        if (measurements.length > 0) {
            StringUtils.appendIndented(out, indent, measurements[0].toString());
            for (int i = 1; i < measurements.length; ++i) {
                StringUtils.appendNewlineIndented(out, indent, measurements[i].toString());
            }
        }
    }

    public static Measurement[] averageMeasurements(Measurement[][] toAverage) {
        ArrayList<String> measurementNames = new ArrayList<String>();
        Measurement[][] arr$ = toAverage;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Measurement[] measurements;
            for (Measurement measurement : measurements = arr$[i$]) {
                if (measurementNames.indexOf(measurement.getName()) >= 0) continue;
                measurementNames.add(measurement.getName());
            }
        }
        GaussianEstimator[] estimators = new GaussianEstimator[measurementNames.size()];
        for (int i = 0; i < estimators.length; ++i) {
            estimators[i] = new GaussianEstimator();
        }
        Measurement[][] arr$2 = toAverage;
        int len$2 = arr$2.length;
        for (int i$ = 0; i$ < len$2; ++i$) {
            Measurement[] measurements;
            for (Measurement measurement : measurements = arr$2[i$]) {
                estimators[measurementNames.indexOf(measurement.getName())].addObservation(measurement.getValue(), 1.0);
            }
        }
        ArrayList<Measurement> averagedMeasurements = new ArrayList<Measurement>();
        for (int i = 0; i < measurementNames.size(); ++i) {
            String mName = (String)measurementNames.get(i);
            GaussianEstimator mEstimator = estimators[i];
            if (!(mEstimator.getTotalWeightObserved() > 1.0)) continue;
            averagedMeasurements.add(new Measurement("[avg] " + mName, mEstimator.getMean()));
            averagedMeasurements.add(new Measurement("[err] " + mName, mEstimator.getStdDev() / Math.sqrt(mEstimator.getTotalWeightObserved())));
        }
        return averagedMeasurements.toArray(new Measurement[averagedMeasurements.size()]);
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
        sb.append(this.getName());
        sb.append(" = ");
        sb.append(StringUtils.doubleToString(this.getValue(), 3));
    }
}

