/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.core.scripting.JythonScript;
import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.template.AbstractScriptTemplate;

public class Jython
extends AbstractScriptTemplate {
    private static final long serialVersionUID = 3861631532032659677L;
    protected JythonScript m_InlineScript;

    public String globalInfo() {
        return "Uses a Jython script to generate a sub-flow.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)this.getDefaultInlineScript());
    }

    public String getQuickInfo() {
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"scriptFile") || !this.m_ScriptFile.isDirectory()) {
            return super.getQuickInfo();
        }
        return QuickInfoHelper.toString((OptionHandler)this, (String)"inlineScript", (Object)Utils.shorten((String)this.m_InlineScript.stringValue(), (int)50));
    }

    public String scriptOptionsTipText() {
        return "The options for the Jython script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the Jython actor.";
    }

    protected JythonScript getDefaultInlineScript() {
        return new JythonScript();
    }

    public void setInlineScript(JythonScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public JythonScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script, if not using an external script file.";
    }

    protected String loadScriptObject() {
        Object[] result = adams.core.scripting.Jython.loadScriptObject(AbstractActorTemplate.class, this.m_ScriptFile, this.m_InlineScript, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    protected String checkScriptObject() {
        return null;
    }

    protected AbstractActor executeScript() {
        return ((AbstractActorTemplate)this.m_ScriptObject).generate();
    }
}

