/*
 * Decompiled with CFR 0.152.
 */
package adams.core.net;

import adams.core.ConsoleObject;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.net.EmailAddress;
import adams.core.net.EmailHelper;
import adams.core.net.InternetHelper;
import java.io.File;
import java.util.ArrayList;
import org.apache.tika.mime.MediaType;

public class Email
extends ConsoleObject {
    private static final long serialVersionUID = -8762979365076025189L;
    public static final String NO_SUBJECT = "(no subject)";
    protected EmailAddress m_From;
    protected EmailAddress[] m_To;
    protected EmailAddress[] m_CC;
    protected EmailAddress[] m_BCC;
    protected String m_Subject;
    protected String m_Body;
    protected File[] m_Attachments;

    public Email(EmailAddress from, EmailAddress to, String subject, String body) {
        this(from, new EmailAddress[]{to}, subject, body, new File[0]);
    }

    public Email(EmailAddress from, EmailAddress to, String subject, String body, File[] attachments) {
        this(from, new EmailAddress[]{to}, subject, body, attachments);
    }

    public Email(EmailAddress from, EmailAddress[] to, String subject, String body, File[] attachments) {
        this(from, to, new EmailAddress[0], new EmailAddress[0], subject, body, attachments);
    }

    public Email(EmailAddress from, EmailAddress[] to, EmailAddress[] cc, EmailAddress[] bcc, String subject, String body, File[] attachments) {
        if (to == null) {
            to = new EmailAddress[]{};
        }
        if (cc == null) {
            cc = new EmailAddress[]{};
        }
        if (bcc == null) {
            bcc = new EmailAddress[]{};
        }
        if (subject.trim().length() == 0) {
            subject = NO_SUBJECT;
        }
        if (attachments == null) {
            attachments = new File[]{};
        }
        if (from == null) {
            throw new IllegalArgumentException("Sender cannot be null!");
        }
        if (to.length + cc.length + bcc.length == 0) {
            throw new IllegalArgumentException("At least one recipient must be specified (to, cc or bcc)!");
        }
        for (int i = 0; i < attachments.length; ++i) {
            if (attachments[i].exists()) continue;
            throw new IllegalArgumentException("Attachment #" + (i + 1) + " does not exist: " + attachments[i]);
        }
        this.m_From = from;
        this.m_To = to;
        this.m_CC = cc;
        this.m_BCC = bcc;
        this.m_Subject = subject;
        this.m_Body = body;
        this.m_Attachments = attachments;
    }

    public EmailAddress getFrom() {
        return this.m_From;
    }

    public EmailAddress[] getTo() {
        return this.m_To;
    }

    public EmailAddress[] getCC() {
        return this.m_CC;
    }

    public EmailAddress[] getBCC() {
        return this.m_BCC;
    }

    public File[] getAttachments() {
        return this.m_Attachments;
    }

    public String getSubject() {
        return this.m_Subject;
    }

    public String getBody() {
        return this.m_Body;
    }

    public String toString() {
        return "from=" + (Object)((Object)this.getFrom()) + ", #to=" + this.getTo().length + ", #cc=" + this.getCC().length + ", #bcc=" + this.getBCC().length + ", #attachments=" + this.getAttachments().length + ", subject=" + this.getSubject() + ", len(body)=" + this.getBody().length();
    }

    public String toPlainText() {
        String boundary = EmailHelper.createBoundary();
        ArrayList<String> list = new ArrayList<String>();
        list.add("MIME-Version: 1.0");
        list.add("Sender: " + this.getFrom().strippedValue());
        for (EmailAddress emailAddress : this.getCC()) {
            list.add("CC: " + emailAddress.getValue());
        }
        for (EmailAddress emailAddress : this.getBCC()) {
            list.add("BCC: " + emailAddress.getValue());
        }
        list.add("Subject: " + this.getSubject());
        list.add("From: " + this.getFrom().getValue());
        for (EmailAddress emailAddress : this.getTo()) {
            list.add("To: " + emailAddress.getValue());
        }
        list.add("Content-Type: multipart/mixed; boundary=" + boundary);
        list.add("");
        list.add("--" + boundary);
        list.add("Content-Type: text/plain; charset=ISO-8859-1");
        list.add("");
        list.add(this.getBody());
        list.add("");
        list.add("");
        if (this.getAttachments().length > 0) {
            for (File file : this.getAttachments()) {
                String[] lines;
                list.add("--" + boundary);
                MediaType mime = EmailHelper.getMimeType(file);
                list.add("Content-Type: " + mime.toString() + "; name=\"" + file.getName() + "\"");
                list.add("Content-Disposition: attachment; filename=\"" + file.getName() + "\"");
                list.add("Content-Transfer-Encoding: base64");
                list.add("");
                byte[] content = FileUtils.loadFromBinaryFile((File)file);
                for (String line : lines = EmailHelper.breakUp(InternetHelper.encodeBase64((byte[])content), 76)) {
                    list.add(line);
                }
            }
        }
        list.add("--" + boundary + "--");
        return Utils.flatten(list, (String)"\n");
    }
}

