/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.DateTime;
import adams.core.ExcelHelper;
import adams.core.License;
import adams.core.Stoppable;
import adams.core.Time;
import adams.core.Utils;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BaseString;
import adams.data.io.input.AbstractExcelSpreadSheetReader;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@MixedCopyright(copyright="Apache Foundation", license=License.APACHE2, url="http://poi.apache.org/spreadsheet/how-to.html#xssf_sax_api", note="Adapted example from Apache website")
public class ExcelStreamingSpreadSheetReader
extends AbstractExcelSpreadSheetReader {
    private static final long serialVersionUID = 4755872204697328246L;
    protected SheetHandler m_Handler;
    protected BaseString[] m_CellTypeID;
    protected Cell.ContentType[] m_CellTypeContentType;
    protected BaseString[] m_CellStringID;
    protected Cell.ContentType[] m_CellStringContentType;

    public String globalInfo() {
        return "Reads large MS Excel XML files (using streaming via SAX).\nIncreasing the debug level to more than 1 results in outputting detailed information on cells.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cell-type-id", "cellTypeID", (Object)new BaseString[]{new BaseString("b"), new BaseString("s")});
        this.m_OptionManager.add("cell-type-contenttype", "cellTypeContentType", (Object)new Cell.ContentType[]{Cell.ContentType.BOOLEAN, Cell.ContentType.STRING});
        this.m_OptionManager.add("cell-string-id", "cellStringID", (Object)new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3"), new BaseString("4"), new BaseString("7"), new BaseString("8")});
        this.m_OptionManager.add("cell-string-contenttype", "cellStringContentType", (Object)new Cell.ContentType[]{Cell.ContentType.DATE, Cell.ContentType.TIME, Cell.ContentType.DOUBLE, Cell.ContentType.DATE, Cell.ContentType.DATE, Cell.ContentType.LONG});
    }

    public String getFormatDescription() {
        return "MS Excel spreadsheets (large XML)";
    }

    public String[] getFormatExtensions() {
        return new String[]{"xlsx"};
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.FILE;
    }

    public void setCellTypeID(BaseString[] value) {
        this.m_CellTypeID = value;
        this.reset();
    }

    public BaseString[] getCellTypeID() {
        return this.m_CellTypeID;
    }

    public String cellTypeIDTipText() {
        return "The IDs (= strings) for the cell types to parse.";
    }

    public void setCellTypeContentType(Cell.ContentType[] value) {
        this.m_CellTypeContentType = value;
        this.reset();
    }

    public Cell.ContentType[] getCellTypeContentType() {
        return this.m_CellTypeContentType;
    }

    public String cellTypeContentTypeTipText() {
        return "The corresponding content types for the cell types to parse.";
    }

    public void setCellStringID(BaseString[] value) {
        this.m_CellStringID = value;
        this.reset();
    }

    public BaseString[] getCellStringID() {
        return this.m_CellStringID;
    }

    public String cellStringIDTipText() {
        return "The IDs (= strings) for the cell strings to parse.";
    }

    public void setCellStringContentType(Cell.ContentType[] value) {
        this.m_CellStringContentType = value;
        this.reset();
    }

    public Cell.ContentType[] getCellStringContentType() {
        return this.m_CellStringContentType;
    }

    public String cellStringContentTypeTipText() {
        return "The corresponding content types for the cell strings to parse.";
    }

    protected void check() {
        if (this.m_CellTypeID.length != this.m_CellTypeContentType.length) {
            throw new IllegalStateException("Length of cellTypeID and cellTypeContentType differ: " + this.m_CellTypeID.length + " != " + this.m_CellTypeContentType.length);
        }
        if (this.m_CellStringID.length != this.m_CellStringContentType.length) {
            throw new IllegalStateException("Length of cellStringID and cellStringContentType differ: " + this.m_CellStringID.length + " != " + this.m_CellStringContentType.length);
        }
    }

    protected int getSheetCount(File file) throws Exception {
        OPCPackage pkg = OPCPackage.open((String)file.getAbsolutePath());
        XSSFReader reader = new XSSFReader(pkg);
        Iterator sheets = reader.getSheetsData();
        int result = 0;
        while (sheets.hasNext() && !this.m_Stopped) {
            InputStream sheet = (InputStream)sheets.next();
            sheet.close();
            ++result;
        }
        return result;
    }

    protected List<SpreadSheet> doReadRange(File file) {
        ArrayList<SpreadSheet> result = new ArrayList<SpreadSheet>();
        try {
            this.m_SheetRange.setMax(this.getSheetCount(file));
            HashSet indices = new HashSet(Utils.toList((int[])this.m_SheetRange.getIntIndices()));
            OPCPackage pkg = OPCPackage.open((String)file.getAbsolutePath());
            XSSFReader reader = new XSSFReader(pkg);
            SharedStringsTable sst = reader.getSharedStringsTable();
            Iterator sheets = reader.getSheetsData();
            int count = 0;
            while (sheets.hasNext() && !this.m_Stopped) {
                InputStream sheet = (InputStream)sheets.next();
                if (indices.contains(count)) {
                    SpreadSheet spsheet = new SpreadSheet();
                    spsheet.setDataRowClass(this.m_DataRowType.getRowClass());
                    XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                    this.m_Handler = new SheetHandler(this, spsheet, sst);
                    parser.setContentHandler(this.m_Handler);
                    InputSource sheetSource = new InputSource(sheet);
                    parser.parse(sheetSource);
                    result.add(spsheet);
                }
                sheet.close();
                ++count;
            }
        }
        catch (ParseStopException e) {
            this.getSystemErr().println("Parsing stopped!");
            result = null;
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace("Failed to read spreadsheet:", (Throwable)e);
        }
        if (result != null) {
            if (this.m_Handler.getUnknownCellTypes().size() > 0) {
                this.getSystemErr().println("Unknown cell types: " + this.m_Handler.getUnknownCellTypes());
            }
            if (this.m_Handler.getUnknownCellStrings().size() > 0) {
                this.getSystemErr().println("Unknown cell strings: " + this.m_Handler.getUnknownCellStrings());
            }
        }
        this.m_Handler = null;
        return result;
    }

    public void stopExecution() {
        super.stopExecution();
        if (this.m_Handler != null) {
            this.m_Handler.stopExecution();
        }
    }

    @MixedCopyright(copyright="Apache Foundation", license=License.APACHE2, url="http://poi.apache.org/spreadsheet/how-to.html#xssf_sax_api", note="Adapted example from Apache website")
    public static class SheetHandler
    extends DefaultHandler
    implements Stoppable {
        protected ExcelStreamingSpreadSheetReader m_Owner;
        protected SpreadSheet m_Sheet;
        protected SharedStringsTable m_SST;
        protected StringBuilder m_LastContents;
        protected Cell.ContentType m_ContentType;
        protected String m_Reference;
        protected boolean m_Stopped;
        protected HashMap<String, Cell.ContentType> m_CellTypes;
        protected HashMap<String, Cell.ContentType> m_CellStrings;
        protected HashSet<String> m_UnknownCellTypes;
        protected HashSet<String> m_UnknownCellStrings;

        public SheetHandler(ExcelStreamingSpreadSheetReader owner, SpreadSheet sheet, SharedStringsTable sst) {
            int i;
            this.m_Owner = owner;
            this.m_Sheet = sheet;
            this.m_SST = sst;
            this.m_LastContents = new StringBuilder();
            this.m_Reference = "";
            this.m_ContentType = Cell.ContentType.MISSING;
            this.m_Stopped = false;
            this.m_CellTypes = new HashMap();
            this.m_CellStrings = new HashMap();
            this.m_UnknownCellTypes = new HashSet();
            this.m_UnknownCellStrings = new HashSet();
            for (i = 0; i < this.m_Owner.getCellTypeID().length; ++i) {
                this.m_CellTypes.put(this.m_Owner.getCellTypeID()[i].stringValue(), this.m_Owner.getCellTypeContentType()[i]);
            }
            for (i = 0; i < this.m_Owner.getCellStringID().length; ++i) {
                this.m_CellStrings.put(this.m_Owner.getCellStringID()[i].stringValue(), this.m_Owner.getCellStringContentType()[i]);
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("c")) {
                this.m_Reference = attributes.getValue("r");
                if (this.m_Owner.isDebugOn()) {
                    this.m_Owner.debug("ref: " + this.m_Reference);
                }
                String cellType = attributes.getValue("t");
                if (this.m_Owner.getDebugLevel() > 1) {
                    this.m_Owner.debug("  cellType: " + cellType);
                }
                String cellStr = attributes.getValue("s");
                if (this.m_Owner.getDebugLevel() > 1) {
                    this.m_Owner.debug("  cellStr: " + cellStr);
                }
                this.m_ContentType = Cell.ContentType.DOUBLE;
                if ("e".equals(cellStr)) {
                    this.m_ContentType = null;
                } else if (cellType != null) {
                    if (this.m_CellTypes.containsKey(cellType)) {
                        this.m_ContentType = this.m_CellTypes.get(cellType);
                    } else {
                        this.m_UnknownCellTypes.add(cellType);
                    }
                } else if (cellStr != null) {
                    if (this.m_CellStrings.containsKey(cellStr)) {
                        this.m_ContentType = this.m_CellStrings.get(cellStr);
                    } else {
                        this.m_UnknownCellStrings.add(cellStr);
                    }
                }
                if (this.m_Owner.getDebugLevel() > 1) {
                    this.m_Owner.debug("  contentType: " + this.m_ContentType);
                }
            }
            if (this.m_LastContents.length() > 0) {
                this.m_LastContents.delete(0, this.m_LastContents.length());
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.m_ContentType) {
                case STRING: {
                    int idx = Integer.parseInt(this.m_LastContents.toString());
                    this.m_LastContents = new StringBuilder(new XSSFRichTextString(this.m_SST.getEntryAt(idx)).toString());
                }
            }
            if (name.equals("v")) {
                try {
                    String content = this.m_LastContents.toString();
                    if (this.m_Owner.isDebugOn()) {
                        this.m_Owner.debug("  content: " + content);
                    }
                    int[] loc = ExcelHelper.getCellLocation(this.m_Reference);
                    while (this.m_Sheet.getRowCount() < loc[0]) {
                        this.m_Sheet.addRow();
                    }
                    while (this.m_Sheet.getColumnCount() <= loc[1]) {
                        this.m_Sheet.insertColumn(this.m_Sheet.getColumnCount(), "col" + (this.m_Sheet.getColumnCount() + 1));
                    }
                    if (loc[0] == 0) {
                        HeaderRow row = this.m_Sheet.getHeaderRow();
                        Cell cell = row.addCell(loc[1]);
                        if (content.equals(this.m_Owner.getMissingValue())) {
                            cell.setMissing();
                        } else {
                            cell.setContent(content);
                        }
                    } else {
                        DataRow row = this.m_Sheet.getRow(loc[0] - 1);
                        Cell cell = row.addCell(loc[1]);
                        if (content.equals(this.m_Owner.getMissingValue())) {
                            cell.setMissing();
                        } else if (this.m_ContentType == null) {
                            cell.setContent(content);
                        } else {
                            switch (this.m_ContentType) {
                                case STRING: {
                                    cell.setContentAsString(content);
                                    break;
                                }
                                case BOOLEAN: {
                                    cell.setContent(new Boolean(!content.equals("0")));
                                    break;
                                }
                                case DATE: {
                                    cell.setContent(DateUtil.getJavaDate((double)Double.parseDouble(content)));
                                    break;
                                }
                                case DATETIME: {
                                    cell.setContent(new DateTime(DateUtil.getJavaDate((double)Double.parseDouble(content))));
                                    break;
                                }
                                case TIME: {
                                    cell.setContent(new Time(DateUtil.getJavaDate((double)Double.parseDouble(content))));
                                    break;
                                }
                                case LONG: {
                                    cell.setContent(new Long(content));
                                    break;
                                }
                                case DOUBLE: {
                                    cell.setContent(new Double(content));
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.m_Owner.getSystemErr().printStackTrace("Failed to set cell content at " + this.m_Reference + " (rows=" + this.m_Sheet.getRowCount() + ", cols=" + this.m_Sheet.getColumnCount() + "):", (Throwable)e);
                }
            }
            this.m_ContentType = Cell.ContentType.MISSING;
            if (this.m_Stopped) {
                throw new ParseStopException("", null);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.m_LastContents.append(ch, start, length);
        }

        public void stopExecution() {
            this.m_Stopped = true;
        }

        public HashSet<String> getUnknownCellTypes() {
            return this.m_UnknownCellTypes;
        }

        public HashSet<String> getUnknownCellStrings() {
            return this.m_UnknownCellStrings;
        }
    }

    public static class ParseStopException
    extends SAXParseException {
        private static final long serialVersionUID = -5378507296511062333L;

        public ParseStopException(String message, Locator locator) {
            super(message, locator);
        }
    }
}

