/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.filter.AbstractFilter;
import adams.data.filter.CropToCentroid;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;

public class Centroid
extends AbstractFilter<Heatmap>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 2270876952032422552L;
    public static final String CENTROID_X = "Centroid.X";
    public static final String CENTROID_Y = "Centroid.Y";
    protected int m_NumIterations;
    protected double m_ShrinkFactor;

    public String globalInfo() {
        return "Computes the centroid of a heatmap and adds this to the heatmap's report.\nIt is possible to perform multiple iterations and each time with a shrunken heatmap. This is useful if the centroid cannot be computed reliably the first time.\nFor more information on the centroid calculation, see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "WikiPedia");
        result.setValue(TechnicalInformation.Field.TITLE, "Image moment");
        result.setValue(TechnicalInformation.Field.HTTP, "http://en.wikipedia.org/wiki/Image_moment");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-iterations", "numIterations", (Object)1, (Number)1, null);
        this.m_OptionManager.add("shrink-factor", "shrinkFactor", (Object)0.75, (Number)0.001, (Number)0.999);
    }

    public void setNumIterations(int value) {
        if (value > 0) {
            this.m_NumIterations = value;
            this.reset();
        } else {
            this.getSystemErr().println("NumIterations must be > 0, provided: " + value);
        }
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public String numIterationsTipText() {
        return "The number of iterations to perform for finding the centroid.";
    }

    public void setShrinkFactor(double value) {
        if (value > 0.0 && value < 1.0) {
            this.m_ShrinkFactor = value;
            this.reset();
        } else {
            this.getSystemErr().println("ShrinkFactor must be 0 < x < 1, provided: " + value);
        }
    }

    public double getShrinkFactor() {
        return this.m_ShrinkFactor;
    }

    public String shrinkFactorTipText() {
        return "The factor to shrink the heatmap with after each iteration.";
    }

    protected Heatmap findCentroid(Heatmap data) {
        double y_bar;
        double x_bar;
        Heatmap result = data.getClone();
        double m00 = 0.0;
        double m01 = 0.0;
        double m10 = 0.0;
        for (int y = 0; y < data.getHeight(); ++y) {
            for (int x = 0; x < data.getWidth(); ++x) {
                m00 += data.get(y, x);
                m10 += (double)x * data.get(y, x);
                m01 += (double)y * data.get(y, x);
            }
        }
        if (m00 > 0.0) {
            x_bar = m10 / m00;
            y_bar = m01 / m00;
        } else {
            x_bar = -1.0;
            y_bar = -1.0;
        }
        Field field = new Field(CENTROID_X, DataType.NUMERIC);
        result.getReport().addField((AbstractField)field);
        result.getReport().setValue((AbstractField)field, (Object)x_bar);
        field = new Field(CENTROID_Y, DataType.NUMERIC);
        result.getReport().addField((AbstractField)field);
        result.getReport().setValue((AbstractField)field, (Object)y_bar);
        if (this.isDebugOn()) {
            this.debug("M00: " + m00 + ", M10: " + m10 + ", M01: " + m01);
            this.debug("x bar: " + x_bar + ", y bar: " + y_bar);
        }
        return result;
    }

    protected Heatmap processData(Heatmap data) {
        Heatmap result = data.getClone();
        Heatmap current = data.getClone();
        double oldX = -1.0;
        double oldY = -1.0;
        int offsetX = 0;
        int offsetY = 0;
        for (int i = 0; i < this.m_NumIterations; ++i) {
            current = this.findCentroid(current);
            double newX = current.getReport().getDoubleValue(CENTROID_X);
            double newY = current.getReport().getDoubleValue(CENTROID_Y);
            result.getReport().setNumericValue(CENTROID_X, newX + (double)offsetX);
            result.getReport().setNumericValue(CENTROID_Y, newY + (double)offsetY);
            if (i < this.m_NumIterations - 1 && newX == oldX && newY == oldY) {
                result.getNotes().addWarning(((Object)((Object)this)).getClass(), "Stopped after iteration #" + (i + 1) + " since centroid did not change.");
                break;
            }
            int width = (int)Math.round((double)data.getWidth() * this.m_ShrinkFactor);
            int height = (int)Math.round((double)data.getHeight() * this.m_ShrinkFactor);
            current = CropToCentroid.crop(current, (int)Math.round(newY), (int)Math.round(newX), height, width);
            offsetX += current.getReport().getDoubleValue("Crop.Left").intValue();
            offsetY += current.getReport().getDoubleValue("Crop.Top").intValue();
        }
        return result;
    }
}

