/*
 * Decompiled with CFR 0.152.
 */
package adams.data.instances;

import adams.data.heatmap.Heatmap;
import adams.data.heatmap.HeatmapValue;
import adams.data.instances.AbstractFieldInstanceGenerator;
import adams.data.report.Field;
import java.util.ArrayList;
import java.util.Iterator;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class HistogramInstanceGenerator
extends AbstractFieldInstanceGenerator {
    private static final long serialVersionUID = 5945330303794139996L;
    public static final String PREFIX_BIN = "Bin-";
    protected double m_MinIntensity;
    protected double m_MaxIntensity;
    protected int m_NumBins;
    protected boolean m_OnlyIndicators;

    public String globalInfo() {
        return "A generator for turning a heatmap and fields of its report into weka.core.Instance objects.\nZero values are omitted.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-intensity", "minIntensity", (Object)-1.0, (Number)-1.0, null);
        this.m_OptionManager.add("max-intensity", "maxIntensity", (Object)-1.0, (Number)-1.0, null);
        this.m_OptionManager.add("num-bins", "numBins", (Object)100);
        this.m_OptionManager.add("only-indicators", "onlyIndicators", (Object)false);
    }

    public void setMinIntensity(double value) {
        if (value > 0.0 || value == -1.0) {
            this.m_MinIntensity = value;
            this.reset();
        } else {
            this.getSystemErr().println(((Object)((Object)this)).getClass().getName() + ": only positive numbers or -1 are allowed for the minimum intensity " + "(provided: " + value + ")!");
        }
    }

    public double getMinIntensity() {
        return this.m_MinIntensity;
    }

    public String minIntensityTipText() {
        return "The minimum intensity to keep.";
    }

    public void setMaxIntensity(double value) {
        if (value > 0.0 || value == -1.0) {
            this.m_MaxIntensity = value;
            this.reset();
        } else {
            this.getSystemErr().println(((Object)((Object)this)).getClass().getName() + ": only positive numbers or -1 are allowed for the maximum intensity " + "(provided: " + value + ")!");
        }
    }

    public double getMaxIntensity() {
        return this.m_MaxIntensity;
    }

    public String maxIntensityTipText() {
        return "The maximum intensity to keep.";
    }

    public void setNumBins(int value) {
        this.m_NumBins = value;
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to use for the histogram.";
    }

    public void setOnlyIndicators(boolean value) {
        this.m_OnlyIndicators = value;
    }

    public boolean getOnlyIndicators() {
        return this.m_OnlyIndicators;
    }

    public String onlyIndicatorsTipText() {
        return "Whether to output only indicator attributes instead of counts.";
    }

    @Override
    protected void checkHeader(Heatmap data) {
        int size = this.m_OutputHeader.numAttributes();
        if (this.m_AddDatabaseID) {
            --size;
        }
        if (size != this.m_Fields.length + this.m_NumBins) {
            throw new IllegalStateException("Number of fields+bins and output attributes differ (" + data + "): " + this.m_Fields.length + "+" + this.m_NumBins + " != " + size);
        }
    }

    protected void generateHeader(Heatmap data) {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < this.m_NumBins; ++i) {
            if (this.m_OnlyIndicators) {
                ArrayList<String> attValues = new ArrayList<String>();
                attValues.add("false");
                attValues.add("true");
                atts.add(new Attribute(PREFIX_BIN + (i + 1), attValues));
                continue;
            }
            atts.add(new Attribute(PREFIX_BIN + (i + 1)));
        }
        StringBuilder name = new StringBuilder();
        for (Field target : this.m_Fields) {
            atts.add(this.createAttribute(target, name));
        }
        this.m_OutputHeader = new Instances(((Object)((Object)this)).getClass().getName() + "-" + name.toString(), atts, 0);
    }

    protected Instance generateOutput(Heatmap data) {
        int i;
        double[] values = new double[this.m_OutputHeader.numAttributes()];
        for (i = 0; i < values.length; ++i) {
            values[i] = Utils.missingValue();
        }
        double min = this.m_MinIntensity == -1.0 ? data.getMin() : this.m_MinIntensity;
        double max = this.m_MaxIntensity == -1.0 ? data.getMax() : this.m_MaxIntensity;
        double diff = (max - min) / (double)(this.m_NumBins - 1);
        int[] bins = new int[this.m_NumBins];
        Iterator<HeatmapValue> iter = data.iterator();
        while (iter.hasNext()) {
            int index;
            HeatmapValue mvalue = iter.next();
            if (mvalue.getValue() == 0.0 || (index = (int)((mvalue.getValue() - min) / diff)) < 0) continue;
            int n = index;
            bins[n] = bins[n] + 1;
        }
        int offset = 0;
        if (this.m_AddDatabaseID) {
            ++offset;
        }
        for (i = 0; i < this.m_NumBins; ++i) {
            values[offset + i] = this.m_OnlyIndicators ? (bins[i] == 0 ? 0.0 : 1.0) : (double)bins[i];
        }
        this.addFields(data, values);
        DenseInstance result = new DenseInstance(1.0, values);
        result.setDataset(this.m_OutputHeader);
        return result;
    }
}

