/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;

public class SpreadSheetAddFormulaRow
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = 6046280641743329345L;
    public static final String PLACEHOLDER_COLUMN = "@";
    public static final String PLACEHOLDER_LAST_ROW = "#";
    protected String m_Formula;
    protected SpreadSheetColumnRange m_Columns;

    public String globalInfo() {
        return "Adds a row with a user-supplied formula for the specified columns.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("formula", "formula", (Object)"=sum(@1:@#)");
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public void setFormula(String value) {
        this.m_Formula = value;
        this.reset();
    }

    public String getFormula() {
        return this.m_Formula;
    }

    public String formulaTipText() {
        return "The formula to add (incl '='); use '@' as placeholder for the current column and '#' for the last row.";
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The range of columns to add the formula for; " + this.m_Columns.getExample();
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = this.m_NoCopy ? input : input.getClone();
        this.m_Columns.setSpreadSheet(result);
        int[] cols = this.m_Columns.getIntIndices();
        DataRow row = result.addRow();
        for (int i = 0; i < cols.length; ++i) {
            String formula = this.m_Formula.replace(PLACEHOLDER_COLUMN, SpreadSheet.getColumnPosition((int)cols[i]));
            formula = formula.replace(PLACEHOLDER_LAST_ROW, Integer.toString(result.getRowCount()));
            row.addCell(cols[i]).setFormula(formula);
        }
        return result;
    }
}

