/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractSpreadSheetColumnConverter;
import adams.data.spreadsheet.Cell;

public class SpreadSheetDoubleColumnToString
extends AbstractSpreadSheetColumnConverter {
    private static final long serialVersionUID = 8681800940519018023L;
    protected int m_NumDecimals;
    protected boolean m_FixedDecimals;

    public String globalInfo() {
        return "Converts the specified spreadsheet double column to string.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("fixed-decimals", "fixedDecimals", (Object)false);
    }

    @Override
    public String columnTipText() {
        return "The double column to convert to string; " + this.m_Column.getExample();
    }

    public void setNumDecimals(int value) {
        if (value >= 0 || value == -1) {
            this.m_NumDecimals = value;
            this.reset();
        } else {
            this.getSystemErr().println("Number of decimals cannot be negative!");
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals for numeric values to use; -1 uses Java's Double.toString() method.";
    }

    public void setFixedDecimals(boolean value) {
        this.m_FixedDecimals = value;
        this.reset();
    }

    public boolean getFixedDecimals() {
        return this.m_FixedDecimals;
    }

    public String fixedDecimalsTipText() {
        return "If enabled and 'num-decimals' is specified, a fixed number of decimals will get output (incl. trailing zeroes), otherwise up-to 'num-decimals'.";
    }

    @Override
    protected void convert(Cell cellOld, Cell cellNew) throws Exception {
        if (this.m_NumDecimals == -1) {
            cellNew.setContentAsString(cellOld.toDouble().toString());
        } else if (this.m_FixedDecimals) {
            cellNew.setContentAsString(Utils.doubleToStringFixed((double)cellOld.toDouble(), (int)this.m_NumDecimals));
        } else {
            cellNew.setContentAsString(Utils.doubleToString((double)cellOld.toDouble(), (int)this.m_NumDecimals));
        }
    }
}

