/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.MultiSheetSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.output.WriterOutputStream;

public abstract class AbstractMultiSheetSpreadSheetWriter
extends AbstractSpreadSheetWriter
implements MultiSheetSpreadSheetWriter {
    private static final long serialVersionUID = -9004877579871173007L;
    protected String m_SheetPrefix;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sheet-prefix", "sheetPrefix", (Object)this.getDefaultSheetPrefix());
    }

    protected String getDefaultSheetPrefix() {
        return "Sheet";
    }

    public void setSheetPrefix(String value) {
        this.m_SheetPrefix = value;
        this.reset();
    }

    public String getSheetPrefix() {
        return this.m_SheetPrefix;
    }

    public String sheetPrefixTipText() {
        return "The prefix for sheet names.";
    }

    protected boolean doWrite(SpreadSheet content, Writer writer) {
        return this.doWrite(new SpreadSheet[]{content}, writer);
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        return this.doWrite(new SpreadSheet[]{content}, out);
    }

    protected boolean doWrite(SpreadSheet[] content, Writer writer) {
        return false;
    }

    protected boolean doWrite(SpreadSheet[] content, OutputStream out) {
        return false;
    }

    @Override
    public boolean write(SpreadSheet[] content, File file) {
        return this.write(content, file.getAbsolutePath());
    }

    @Override
    public boolean write(SpreadSheet[] content, String filename) {
        boolean result = true;
        try {
            if (this.getUseOutputStream()) {
                FileOutputStream output = new FileOutputStream(filename, false);
                result = this.doWrite(content, (OutputStream)output);
                ((OutputStream)output).close();
            } else {
                BufferedWriter writer = new BufferedWriter(new FileWriter(filename, false));
                result = this.doWrite(content, (Writer)writer);
                writer.close();
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean write(SpreadSheet[] content, OutputStream stream) {
        if (this.getUseOutputStream()) {
            return this.doWrite(content, stream);
        }
        return this.doWrite(content, (Writer)new OutputStreamWriter(stream));
    }

    @Override
    public boolean write(SpreadSheet[] content, Writer writer) {
        if (this.getUseOutputStream()) {
            return this.doWrite(content, (OutputStream)new WriterOutputStream(writer));
        }
        return this.doWrite(content, writer);
    }
}

