/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.Index;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SpreadSheetColumnIndex
extends Index {
    private static final long serialVersionUID = -4358263779315198808L;
    protected SpreadSheet m_Sheet;
    protected List<String> m_Names;
    protected HashMap<String, Integer> m_Indices;

    public SpreadSheetColumnIndex() {
    }

    public SpreadSheetColumnIndex(String index) {
        super(index);
    }

    public SpreadSheetColumnIndex(String index, int max) {
        super(index, max);
    }

    protected void initialize() {
        super.initialize();
        this.m_Sheet = null;
        this.m_Names = null;
        this.m_Indices = null;
    }

    public void setSpreadSheet(SpreadSheet value) {
        this.m_Sheet = value;
        this.m_Names = null;
        if (this.m_Sheet == null) {
            this.setMax(-1);
        } else {
            this.setMax(value.getColumnCount());
        }
    }

    public SpreadSheet getSpreadSheet() {
        return this.m_Sheet;
    }

    protected synchronized List<String> getNames() {
        if (this.m_Names == null) {
            this.m_Names = new ArrayList<String>();
            this.m_Indices = new HashMap();
            HeaderRow header = this.m_Sheet.getHeaderRow();
            for (int i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                String col = header.getCell(i).getContent();
                this.m_Names.add(col);
                this.m_Indices.put(col, i);
            }
            Collections.sort(this.m_Names);
            Collections.reverse(this.m_Names);
        }
        return this.m_Names;
    }

    public synchronized HashMap<String, Integer> getIndices() {
        if (this.m_Names == null) {
            this.getNames();
        }
        return this.m_Indices;
    }

    protected String replaceColumnName(String s) {
        String result = s.trim();
        List<String> names = this.getNames();
        for (int i = 0; i < names.size(); ++i) {
            if (!result.equals(names.get(i))) continue;
            result = Integer.toString(this.getIndices().get(names.get(i)) + 1);
            break;
        }
        return result;
    }

    protected boolean isColumnName(String s) {
        boolean result = false;
        List<String> names = this.getNames();
        for (int i = 0; i < names.size(); ++i) {
            if (!s.equals(names.get(i))) continue;
            result = true;
            break;
        }
        return result;
    }

    protected String clean(String s) {
        if (this.m_Sheet == null) {
            if (this.isPlaceholder(s)) {
                return super.clean(s);
            }
            return s;
        }
        if (this.isColumnName(s)) {
            return s;
        }
        return super.clean(s);
    }

    protected int parse(String s, int max) {
        if (this.m_Sheet == null) {
            return super.parse(s, max);
        }
        return super.parse(this.replaceColumnName(s), max);
    }

    public String getExample() {
        return "An index is a number starting with 1; apart from column names (case-sensitive), the following placeholders can be used as well: first, second, third, last_2, last_1, last";
    }
}

