/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.Range;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SpreadSheetColumnRange
extends Range {
    private static final long serialVersionUID = 5215987200366396733L;
    protected SpreadSheet m_Sheet;
    protected List<String> m_Names;
    protected HashMap<String, Integer> m_Indices;

    public SpreadSheetColumnRange() {
    }

    public SpreadSheetColumnRange(String range) {
        super(range);
    }

    public SpreadSheetColumnRange(String range, int max) {
        super(range, max);
    }

    protected void initialize() {
        super.initialize();
        this.m_Sheet = null;
        this.m_Names = null;
        this.m_Indices = null;
    }

    public void setSpreadSheet(SpreadSheet value) {
        this.m_Sheet = value;
        this.m_Names = null;
        if (this.m_Sheet == null) {
            this.setMax(-1);
        } else {
            this.setMax(value.getColumnCount());
        }
    }

    public SpreadSheet getSpreadSheet() {
        return this.m_Sheet;
    }

    protected synchronized List<String> getNames() {
        if (this.m_Names == null) {
            this.m_Names = new ArrayList<String>();
            if (this.m_Sheet != null) {
                this.m_Indices = new HashMap();
                HeaderRow header = this.m_Sheet.getHeaderRow();
                for (int i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                    String col = header.getCell(i).getContent();
                    if (col.indexOf("-") > -1) {
                        col = "\"" + col + "\"";
                    } else if (col.indexOf(",") > -1) {
                        col = "\"" + col + "\"";
                    }
                    this.m_Names.add(col);
                    this.m_Indices.put(col, i);
                }
                Collections.sort(this.m_Names);
                Collections.reverse(this.m_Names);
            }
        }
        return this.m_Names;
    }

    public synchronized HashMap<String, Integer> getIndices() {
        if (this.m_Names == null) {
            this.getNames();
        }
        return this.m_Indices;
    }

    protected boolean isColumnName(String s) {
        boolean result = false;
        List<String> names = this.getNames();
        for (int i = 0; i < names.size(); ++i) {
            if (!s.equals(names.get(i))) continue;
            result = true;
            break;
        }
        return result;
    }

    protected List<String> getPlaceholders() {
        List result = super.getPlaceholders();
        result.addAll(this.getNames());
        return result;
    }

    protected boolean canReplaceInvalidChars() {
        return this.m_Sheet != null;
    }

    protected String[] splitRange(String s) {
        return SpreadSheetUtils.split(s, "-".charAt(0));
    }

    protected String[] splitList(String s) {
        return SpreadSheetUtils.split(s, ",".charAt(0));
    }

    protected int parse(String s, int max) {
        if (this.isColumnName(s)) {
            return this.getIndices().get(s);
        }
        return super.parse(s, max);
    }
}

